/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GenericVoWizardPage
extends WizardPage {
    private GenericVirtualOrganization initialVo;
    private Text nameText;

    public GenericVoWizardPage() {
        super("genericVOPage", "Generic VO", null);
        this.setDescription("Specify the attributes of your VO");
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("VO Name:");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nameText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gridData);
        if (this.initialVo != null) {
            this.initVo(this.initialVo);
        }
        this.setControl((Control)composite2);
    }

    protected boolean createVo() {
        String string = null;
        GenericVirtualOrganization genericVirtualOrganization = null;
        IVoManager iVoManager = GridModel.getVoManager();
        this.setErrorMessage(string);
        GenericVoCreator genericVoCreator = this.getVoCreator();
        if (this.isEmpty(genericVoCreator.getVoName())) {
            string = "You have to specify a valid name";
        } else {
            try {
                if (this.initialVo != null) {
                    genericVoCreator.apply(this.initialVo);
                } else {
                    genericVirtualOrganization = (GenericVirtualOrganization)iVoManager.create((IGridElementCreator)genericVoCreator);
                }
            }
            catch (GridModelException gridModelException) {
                string = gridModelException.getLocalizedMessage();
            }
        }
        if (string != null) {
            this.setErrorMessage(string);
            if (genericVirtualOrganization != null) {
                try {
                    iVoManager.delete((IGridElement)genericVirtualOrganization);
                }
                catch (GridModelException gridModelException) {}
            }
        }
        return string == null;
    }

    protected void initVo(GenericVirtualOrganization genericVirtualOrganization) {
        this.nameText.setText(genericVirtualOrganization != null ? genericVirtualOrganization.getName() : "");
        this.nameText.setEnabled(genericVirtualOrganization == null);
    }

    protected void setInitialVo(GenericVirtualOrganization genericVirtualOrganization) {
        this.initialVo = genericVirtualOrganization;
    }

    private GenericVoCreator getVoCreator() {
        GenericVoCreator genericVoCreator = new GenericVoCreator();
        String string = this.nameText.getText();
        genericVoCreator.setVoName(string);
        return genericVoCreator;
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

