/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.project.GridProjectNature;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.GridProjectProperties;
import eu.geclipse.ui.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.service.prefs.BackingStoreException;

public class GridProjectCreationOperation
implements IRunnableWithProgress {
    private GridProjectProperties properties;
    private IProject gridProject;

    public GridProjectCreationOperation(GridProjectProperties gridProjectProperties) {
        this.properties = gridProjectProperties;
        this.gridProject = null;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iProgressMonitor.beginTask(Messages.getString("GridProjectCreationOperation.create_task"), 300);
        try {
            try {
                IProject iProject = this.createProject(this.properties, iProgressMonitor);
                this.addProjectNature(iProject, iProgressMonitor);
                this.gridProject = iProject;
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IProject getProject() {
        return this.gridProject;
    }

    private IProject createProject(GridProjectProperties gridProjectProperties, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString("GridProjectCreationOperation.init_task"));
        String string = gridProjectProperties.getProjectName();
        IPath iPath = gridProjectProperties.getProjectLocation();
        IProject[] iProjectArray = gridProjectProperties.getReferencesProjects();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IStatus iStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(iProject, iPath);
        if (iStatus.getSeverity() != 0) {
            throw new CoreException(iStatus);
        }
        IProjectDescription iProjectDescription = iProject.getWorkspace().newProjectDescription(string);
        iProjectDescription.setLocation(iPath);
        if (iProjectArray != null) {
            iProjectDescription.setReferencedProjects(iProjectArray);
        }
        iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
        iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
        this.createProjectStructure(iProject);
        this.setProjectProperties(iProject, gridProjectProperties);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return iProject;
    }

    private void addProjectNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString("GridProjectCreationOperation.nature_task"));
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String string = GridProjectNature.getID();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && !bl) {
            if (stringArray[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = string;
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createProjectDirectory(IProject iProject, String string) {
        IFolder iFolder = iProject.getFolder((IPath)new Path(string));
        if (!iFolder.exists()) {
            try {
                iFolder.create(1, true, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
    }

    private void createProjectStructure(IProject iProject) {
        this.createProjectDirectory(iProject, IGridProject.DIR_MOUNTS);
        this.createProjectDirectory(iProject, IGridProject.DIR_JOBDESCRIPTIONS);
        this.createProjectDirectory(iProject, IGridProject.DIR_JOBS);
        this.createProjectDirectory(iProject, IGridProject.DIR_WORKFLOWS);
    }

    private void setProjectProperties(IProject iProject, GridProjectProperties gridProjectProperties) throws CoreException {
        IVirtualOrganization iVirtualOrganization = gridProjectProperties.getProjectVo();
        String string = iVirtualOrganization.getName();
        ProjectScope projectScope = new ProjectScope(iProject);
        IEclipsePreferences iEclipsePreferences = projectScope.getNode("eu.geclipse.core");
        iEclipsePreferences.put("vo", string);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Status status = new Status(4, "eu.geclipse.ui", 8, Messages.getString("GridProjectCreationOperation.set_preferences_failed"), (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
    }
}

