/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.GridProjectCreationOperation;
import eu.geclipse.ui.wizards.GridProjectProperties;
import eu.geclipse.ui.wizards.Messages;
import eu.geclipse.ui.wizards.VoSelectionWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public class NewGridProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage creationPage;
    private VoSelectionWizardPage voPage;
    private WizardNewProjectReferencePage referencePage;
    private IProject project = null;

    public boolean performFinish() {
        IProject iProject = this.createNewProject();
        return iProject != null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(Messages.getString("NewGridProjectWizard.windowTitle"));
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/newgridprj_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
    }

    public void addPages() {
        this.creationPage = new WizardNewProjectCreationPage("newGridProjectBasicPage");
        this.creationPage.setTitle(Messages.getString("NewGridProjectWizard.basic_page_title"));
        this.creationPage.setDescription(Messages.getString("NewGridProjectWizard.basic_page_description"));
        this.addPage((IWizardPage)this.creationPage);
        this.voPage = new VoSelectionWizardPage(false);
        this.addPage((IWizardPage)this.voPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("newGridProjectReferencePage");
            this.referencePage.setTitle(Messages.getString("NewGridProjectWizard.reference_page_title"));
            this.referencePage.setDescription(Messages.getString("NewGridProjectWizard.reference_page_description"));
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public boolean canFinish() {
        boolean bl = false;
        IWizardPage iWizardPage = this.getContainer().getCurrentPage();
        if (iWizardPage != this.creationPage) {
            bl = super.canFinish();
        }
        return bl;
    }

    private IProject createNewProject() {
        if (this.project == null && this.creationPage != null) {
            GridProjectProperties gridProjectProperties = new GridProjectProperties();
            gridProjectProperties.setProjectName(this.creationPage.getProjectName());
            gridProjectProperties.setProjectLocation(this.creationPage.useDefaults() ? null : this.creationPage.getLocationPath());
            gridProjectProperties.setProjectVo(this.voPage.getSelectedVos()[0]);
            if (this.referencePage != null) {
                gridProjectProperties.setReferencesProjects(this.referencePage.getReferencedProjects());
            }
            GridProjectCreationOperation gridProjectCreationOperation = new GridProjectCreationOperation(gridProjectProperties);
            WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)gridProjectCreationOperation);
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
                this.project = gridProjectCreationOperation.getProject();
            }
            catch (InterruptedException interruptedException) {
                Activator.logException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Activator.logException(invocationTargetException);
            }
        }
        return this.project;
    }
}

