/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoSelectionWizardPage
extends WizardPage {
    private List voList;
    private Text infoText;
    private boolean allowMultiSelection;
    private Class<?> voType;

    public VoSelectionWizardPage(boolean bl) {
        this(bl, null);
    }

    public VoSelectionWizardPage(boolean bl, Class<?> clazz) {
        super("voPage", "VO Selection Page", null);
        this.setDescription("Specify the VO that should be used");
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        this.allowMultiSelection = bl;
        this.voType = clazz;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 8);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("&Available VOs");
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 120;
        group.setLayoutData((Object)gridData);
        int n = 2816;
        n = this.allowMultiSelection ? (n |= 2) : (n |= 4);
        this.voList = new List((Composite)group, n);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.voList.setLayoutData((Object)gridData);
        this.voList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VoSelectionWizardPage.this.showSelectedInfo();
                IVirtualOrganization[] iVirtualOrganizationArray = VoSelectionWizardPage.this.getSelectedVos();
                VoSelectionWizardPage.this.setPageComplete(iVirtualOrganizationArray != null);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                VoSelectionWizardPage.this.getWizard().getContainer().showPage(VoSelectionWizardPage.this.getNextPage());
            }
        });
        Button button = new Button((Composite)group, 8);
        button.setText("New &VO...");
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VoSelectionWizardPage.this.createNewVO();
                VoSelectionWizardPage.this.updateVoList();
                VoSelectionWizardPage.this.showSelectedInfo();
                VoSelectionWizardPage.this.setPageComplete(VoSelectionWizardPage.this.getSelectedVos() != null);
            }
        });
        Group group2 = new Group(composite2, 8);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setText("&Info about selected VO");
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 120;
        group2.setLayoutData((Object)gridData);
        this.infoText = new Text((Composite)group2, 2818);
        this.infoText.setEditable(false);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.infoText.setLayoutData((Object)gridData);
        this.updateVoList();
        this.showSelectedInfo();
        this.setPageComplete(this.getSelectedVos() != null);
        this.setControl((Control)composite2);
    }

    public IVirtualOrganization[] getSelectedVos() {
        ArrayList<IVirtualOrganization> arrayList = new ArrayList<IVirtualOrganization>();
        String[] stringArray = this.voList.getSelection();
        if (stringArray != null && stringArray.length != 0) {
            IVoManager iVoManager = GridModel.getVoManager();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                IVirtualOrganization iVirtualOrganization = (IVirtualOrganization)iVoManager.findChild(string);
                if (iVirtualOrganization != null) {
                    arrayList.add(iVirtualOrganization);
                }
                ++n2;
            }
        }
        if (arrayList.isEmpty()) {
            this.setErrorMessage("No valid VO is selected");
        } else {
            this.setErrorMessage(null);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new IVirtualOrganization[arrayList.size()]);
    }

    protected void createNewVO() {
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/newtoken_wiz.gif");
        Wizard wizard = new Wizard(){

            public void addPages() {
                ExtPointWizardSelectionListPage extPointWizardSelectionListPage = new ExtPointWizardSelectionListPage("pagename", "eu.geclipse.ui.newVoWizards", "Create a new VO", "Create a new Virtual Organization of the selected type.", "No VO providers registered.");
                this.addPage((IWizardPage)extPointWizardSelectionListPage);
            }

            public boolean performFinish() {
                return false;
            }
        };
        wizard.setForcePreviousAndNextButtons(true);
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle("Create a new VO");
        wizard.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            try {
                GridModel.getVoManager().saveElements();
            }
            catch (GridModelException gridModelException) {
                this.setErrorMessage("Error while saving new element: " + gridModelException.getLocalizedMessage());
            }
        }
    }

    protected void showSelectedInfo() {
        IVirtualOrganization[] iVirtualOrganizationArray = this.getSelectedVos();
        if (iVirtualOrganizationArray != null) {
            try {
                String string = new String();
                string = String.valueOf(string) + "Name:\n\t" + iVirtualOrganizationArray[0].getName() + '\n';
                string = String.valueOf(string) + "Type:\n\t" + iVirtualOrganizationArray[0].getTypeName() + '\n';
                IGridInfoService iGridInfoService = iVirtualOrganizationArray[0].getInfoService();
                if (iGridInfoService != null) {
                    string = String.valueOf(string) + "\nInformation Service:\n\tName:\n\t\t" + iGridInfoService.getName();
                    string = String.valueOf(string) + "\n\tURI:\n\t\t" + iGridInfoService.getURI().toString();
                }
                IGridService[] iGridServiceArray = iVirtualOrganizationArray[0].getServices();
                string = String.valueOf(string) + "\n\nOther Services:";
                if (iGridServiceArray != null && iGridServiceArray.length > 1) {
                    IGridService[] iGridServiceArray2 = iGridServiceArray;
                    int n = iGridServiceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGridService iGridService = iGridServiceArray2[n2];
                        if (iGridService != iGridInfoService) {
                            string = String.valueOf(string) + "\n\tName:\n\t\t" + iGridService.getName();
                            string = String.valueOf(string) + "\n\tURI:\n\t\t" + iGridService.getURI().toString();
                        }
                        ++n2;
                    }
                } else {
                    string = String.valueOf(string) + "\n\tNone";
                }
                this.infoText.setText(string);
            }
            catch (GridModelException gridModelException) {
                NewProblemDialog.openProblem(this.getShell(), "VO info problem", "Unable to query services for VO " + iVirtualOrganizationArray[0].getName(), gridModelException);
            }
        } else {
            this.infoText.setText("");
        }
    }

    protected void updateVoList() {
        this.voList.removeAll();
        IVoManager iVoManager = GridModel.getVoManager();
        try {
            IGridElement[] iGridElementArray = iVoManager.getChildren(null);
            ArrayList<String> arrayList = new ArrayList<String>();
            IGridElement[] iGridElementArray2 = iGridElementArray;
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement object2 = iGridElementArray2[n2];
                if (this.voType == null || this.voType.isAssignableFrom(object2.getClass())) {
                    arrayList.add(object2.getName());
                }
                ++n2;
            }
            Collections.sort(arrayList);
            for (String string : arrayList) {
                this.voList.add(string);
            }
            IGridElement iGridElement = iVoManager.getDefault();
            if (iGridElement != null && (this.voType == null || this.voType.isAssignableFrom(iGridElement.getClass()))) {
                this.voList.setSelection(new String[]{iGridElement.getName()});
            } else if (this.voList.getItemCount() > 0) {
                this.voList.setSelection(0);
            }
        }
        catch (GridModelException gridModelException) {
            NewProblemDialog.openProblem(this.getShell(), "VO list problem", "Unable to query registered VOs", gridModelException);
        }
    }
}

