/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.deployment;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.IApplicationDeployment;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.DeploymentChooserTreeContentProvider;
import eu.geclipse.ui.providers.DeploymentChooserTreeLabelProvider;
import eu.geclipse.ui.wizards.deployment.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DeploymentChooser
extends WizardPage {
    private TreeViewer treeViewer;
    private boolean flipToNextPageEnabled = false;
    private IApplicationDeployment executeExt;

    public DeploymentChooser(String string) {
        super(string);
        this.setTitle(Messages.getString("Deployment.deployment_chooser_title"));
        this.setDescription(Messages.getString("Deployment.deployment_chooser_description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        this.treeViewer = new TreeViewer(composite2, 2820);
        this.setControl((Control)composite2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.initContents();
            if (this.treeViewer.getTree().getItemCount() == 0) {
                this.setErrorMessage(Messages.getString("Deployment.deployment_chooser_no_extension"));
            }
        }
        super.setVisible(bl);
    }

    private void initContents() {
        this.treeViewer.setContentProvider((IContentProvider)new DeploymentChooserTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DeploymentChooserTreeLabelProvider());
        ExtensionManager extensionManager = new ExtensionManager();
        IExtensionPoint iExtensionPoint = extensionManager.getExtensionPoint("eu.geclipse.core.applicationDeployment");
        this.treeViewer.setInput((Object)iExtensionPoint);
        this.treeViewer.expandAll();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
                    IConfigurationElement iConfigurationElement = (IConfigurationElement)iStructuredSelection.getFirstElement();
                    String string = iConfigurationElement.getAttribute("category");
                    if (string != null && !string.equals("")) {
                        try {
                            Object object = iConfigurationElement.createExecutableExtension("class");
                            if (object instanceof IApplicationDeployment) {
                                DeploymentChooser.this.setExecuteExt((IApplicationDeployment)object);
                            }
                        }
                        catch (CoreException coreException) {
                            Activator.logException(coreException);
                        }
                        DeploymentChooser.this.setFlipToNextPageFlag(true);
                    } else {
                        DeploymentChooser.this.setFlipToNextPageFlag(false);
                    }
                } else {
                    DeploymentChooser.this.setFlipToNextPageFlag(false);
                }
                DeploymentChooser.this.setPageComplete(DeploymentChooser.this.canFlipToNextPage());
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.flipToNextPageEnabled;
    }

    public boolean isPageComplete() {
        return false;
    }

    protected void setFlipToNextPageFlag(boolean bl) {
        this.flipToNextPageEnabled = bl;
    }

    protected void setExecuteExt(IApplicationDeployment iApplicationDeployment) {
        this.executeExt = iApplicationDeployment;
    }

    protected IApplicationDeployment getExecuteExt() {
        return this.executeExt;
    }
}

