/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.deployment;

import eu.geclipse.ui.wizards.deployment.Messages;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeploymentDescription
extends WizardPage
implements ModifyListener,
SelectionListener {
    private Combo date;
    private Button custom;
    private Button automatic;
    private Button createdByDate;
    private Button createdByTime;
    private Button createdByVersion;
    private Button createdByName;
    private Text nameText;
    private Text tagText;
    private String time;
    private final String DEFAULTPROJECTNAME = "geclipse";
    private final String DEFAULTVERSION = "v1.0";

    protected DeploymentDescription(String string) {
        super(string);
        this.setDescription(Messages.getString("Deployment.deployment_description_description"));
        this.setTitle(Messages.getString("Deployment.deployment_description_title"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group(composite2, 2048);
        group.setText(Messages.getString("Deployment.deployment_description_group_method_for"));
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        this.custom = new Button((Composite)group, 16);
        this.custom.setText(Messages.getString("Deployment.deployment_description_method_for_custom"));
        this.custom.addSelectionListener((SelectionListener)this);
        this.automatic = new Button((Composite)group, 16);
        this.automatic.setText(Messages.getString("Deployment.deployment_description_method_for_automatic"));
        this.automatic.setSelection(true);
        this.automatic.addSelectionListener((SelectionListener)this);
        Group group2 = new Group(composite2, 2048);
        group2.setText(Messages.getString("Deployment.deployment_description_group_created_by"));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)gridData);
        this.createdByName = new Button((Composite)group2, 32);
        this.createdByName.setText(Messages.getString("Deployment.deployment_description_tag_by_name"));
        this.createdByName.addSelectionListener((SelectionListener)this);
        this.nameText = new Text((Composite)group2, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener((ModifyListener)this);
        this.createdByDate = new Button((Composite)group2, 32);
        this.createdByDate.setText(Messages.getString("Deployment.deployment_description_tag_by_date"));
        this.createdByDate.addSelectionListener((SelectionListener)this);
        this.date = new Combo((Composite)group2, 2056);
        this.date.setLayoutData((Object)new GridData(514));
        this.initDateCombo();
        this.date.addSelectionListener((SelectionListener)this);
        this.createdByTime = new Button((Composite)group2, 32);
        this.createdByTime.setText(Messages.getString("Deployment.deployment_description_tag_by_time"));
        this.createdByTime.addSelectionListener((SelectionListener)this);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.createdByTime.setLayoutData((Object)gridData);
        this.createdByVersion = new Button((Composite)group2, 32);
        this.createdByVersion.setText(Messages.getString("Deployment.deployment_description_tag_by_version"));
        this.createdByVersion.addSelectionListener((SelectionListener)this);
        this.tagText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.tagText.setLayoutData((Object)gridData);
        this.tagText.setEnabled(false);
        this.tagText.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite2);
    }

    private void initDateCombo() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = dateFormatSymbols.getShortMonths()[gregorianCalendar.get(2)];
        String string2 = "-";
        String string3 = ":";
        this.date.add(String.valueOf(string) + string2 + n3 + string2 + n);
        this.date.add(String.valueOf(n) + string2 + string + string2 + n3);
        this.date.add(String.valueOf(n2) + string2 + n3 + string2 + n);
        this.date.add(String.valueOf(n) + string2 + n2 + string2 + n3);
        this.date.select(0);
        this.time = String.valueOf(n4) + string3 + n5 + string3 + n6;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setMessages();
        if (modifyEvent.getSource().equals(this.nameText)) {
            this.generateTag();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.setMessages();
        if (selectionEvent.getSource().equals(this.custom) && this.custom.getSelection()) {
            this.setWidgets(false);
        }
        if (selectionEvent.getSource().equals(this.automatic) && this.automatic.getSelection()) {
            this.setWidgets(true);
        }
        if (selectionEvent.getSource().equals(this.createdByName) || selectionEvent.getSource().equals(this.createdByDate) || selectionEvent.getSource().equals(this.createdByTime) || selectionEvent.getSource().equals(this.createdByVersion) || selectionEvent.getSource().equals(this.date)) {
            this.tagText.setText(this.generateTag());
        }
    }

    public String getTag() {
        return this.tagText.getText().equals("") ? "geclipse" : this.tagText.getText();
    }

    private void setWidgets(boolean bl) {
        this.createdByName.setEnabled(bl);
        this.createdByDate.setEnabled(bl);
        this.createdByTime.setEnabled(bl);
        this.createdByVersion.setEnabled(bl);
        this.date.setEnabled(bl);
        this.nameText.setEnabled(bl);
        this.tagText.setEnabled(!bl);
    }

    private String generateTag() {
        String string = "";
        if (this.createdByName.getSelection()) {
            string = String.valueOf(string) + this.nameText.getText();
        }
        if (this.createdByDate.getSelection()) {
            string = String.valueOf(string) + " " + this.date.getText();
        }
        if (this.createdByTime.getSelection()) {
            string = String.valueOf(string) + " " + this.time;
        }
        if (this.createdByVersion.getSelection()) {
            string = String.valueOf(string) + " " + "v1.0";
        }
        return string;
    }

    private void setMessages() {
        if (this.tagText.getText().equals("")) {
            this.setErrorMessage(Messages.getString("Deployment.deployment_description_error_message"));
        } else {
            this.setErrorMessage(null);
        }
    }
}

