/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.deployment;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.providers.DeploymentSourceTreeContentProvider;
import eu.geclipse.ui.providers.GridModelLabelProvider;
import eu.geclipse.ui.wizards.deployment.DeploymentWizard;
import eu.geclipse.ui.wizards.deployment.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class DeploymentSource
extends WizardPage {
    private CheckboxTreeViewer sourceTree;
    private Link linkForProperty;

    protected DeploymentSource(String string) {
        super(string);
        this.setDescription(Messages.getString("Deployment.deployment_source_description"));
        this.setTitle(Messages.getString("Deployment.deployment_source_title"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("Deployment.deployment_source_available_referenced_projects"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.sourceTree = new CheckboxTreeViewer(composite2, 2816);
        gridData = new GridData(1808);
        this.sourceTree.getTree().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        composite3.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        composite3.setLayout((Layout)rowLayout);
        Button button = new Button(composite3, 0);
        button.setText(Messages.getString("Deployment.deployment_source_select_all"));
        button.setLayoutData((Object)new RowData(85, 22));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IGridElement[] iGridElementArray = DeploymentSource.this.getReferencedProjects();
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement iGridElement = iGridElementArray[n2];
                    DeploymentSource.this.getSourceTree().setSubtreeChecked((Object)iGridElement, true);
                    ++n2;
                }
                DeploymentSource.this.updatePageComplete();
            }
        });
        Button button2 = new Button(composite3, 0);
        button2.setText(Messages.getString("Deployment.deployment_source_deselect_all"));
        button2.setLayoutData((Object)new RowData(85, 22));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeploymentSource.this.getSourceTree().setAllChecked(false);
                DeploymentSource.this.updatePageComplete();
            }
        });
        Label label2 = new Label(composite2, 258);
        gridData = new GridData(768);
        label2.setLayoutData((Object)gridData);
        this.linkForProperty = new Link(composite2, 0);
        this.linkForProperty.setText(Messages.getString("Deployment.deployment_source_link_for_preference"));
        gridData = new GridData(1);
        this.linkForProperty.setLayoutData((Object)gridData);
        this.linkForProperty.setEnabled(true);
        this.linkForProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPropertyDialogOn((Shell)DeploymentSource.this.getShell(), (IAdaptable)DeploymentSource.this.getGridProject().getResource().getProject(), null, null, null).open();
                ((DeploymentWizard)DeploymentSource.this.getWizard()).initProjects();
                DeploymentSource.this.initContents();
            }
        });
        this.setControl((Control)composite2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.initContents();
        }
        super.setVisible(bl);
    }

    protected void initContents() {
        this.sourceTree.setContentProvider((IContentProvider)new DeploymentSourceTreeContentProvider());
        this.sourceTree.setLabelProvider((IBaseLabelProvider)new GridModelLabelProvider());
        this.sourceTree.setInput((Object)this.getWizard());
        this.sourceTree.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((IGridElement)object).getName().compareToIgnoreCase(((IGridElement)object2).getName());
            }
        });
        this.sourceTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (DeploymentSource.this.getSourceTree().getChecked(checkStateChangedEvent.getElement())) {
                    DeploymentSource.this.getSourceTree().setSubtreeChecked(checkStateChangedEvent.getElement(), true);
                } else {
                    DeploymentSource.this.getSourceTree().setSubtreeChecked(checkStateChangedEvent.getElement(), false);
                    DeploymentSource.this.recursionUnchecked(DeploymentSource.this.getSourceTree(), checkStateChangedEvent.getElement());
                }
                DeploymentSource.this.updatePageComplete();
            }
        });
        this.updatePageComplete();
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    protected void updatePageComplete() {
        this.setPageComplete(false);
        if (this.sourceTree.getCheckedElements().length == 0) {
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("Deployment.deployment_source_is_empty"));
            return;
        }
        this.setPageComplete(this.canFlipToNextPage());
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    public boolean canFlipToNextPage() {
        boolean bl = false;
        if (this.sourceTree.getCheckedElements().length > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isPageComplete() {
        return false;
    }

    protected void recursionUnchecked(CheckboxTreeViewer checkboxTreeViewer, Object object) {
        IGridContainer iGridContainer = ((IGridElement)object).getParent();
        if (!iGridContainer.getName().equals("")) {
            checkboxTreeViewer.setChecked((Object)iGridContainer, false);
            this.recursionUnchecked(checkboxTreeViewer, iGridContainer);
        }
    }

    public CheckboxTreeViewer getSourceTree() {
        return this.sourceTree;
    }

    protected IGridElement[] getReferencedProjects() {
        return ((DeploymentWizard)this.getWizard()).getReferencedProjects();
    }

    protected IGridElement getGridProject() {
        return ((DeploymentWizard)this.getWizard()).getGridProject();
    }
}

