/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.deployment;

import eu.geclipse.core.IApplicationDeployment;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.deployment.DeploymentChooser;
import eu.geclipse.ui.wizards.deployment.DeploymentDescription;
import eu.geclipse.ui.wizards.deployment.DeploymentJob;
import eu.geclipse.ui.wizards.deployment.DeploymentSource;
import eu.geclipse.ui.wizards.deployment.DeploymentTarget;
import eu.geclipse.ui.wizards.deployment.Messages;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DeploymentWizard
extends Wizard {
    public static final String EXT_CLASS = "class";
    public static final String EXT_NAME = "name";
    public static final String EXT_ID = "id";
    public static final String EXT_CATEGORY = "category";
    private DeploymentChooser chooserPage;
    private DeploymentSource sourcePage;
    private DeploymentTarget targetPage;
    private DeploymentDescription descriptionPage;
    private IStructuredSelection selection;
    private IGridElement trueGridProject;
    private IGridElement[] referencedProjects;

    public DeploymentWizard(IStructuredSelection iStructuredSelection) {
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.getString("Deployment.deployment_wizard_window_title"));
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/newtoken_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        this.selection = iStructuredSelection;
        this.initProjects();
    }

    public void addPages() {
        this.chooserPage = new DeploymentChooser(Messages.getString("Deployment.deployment_wizard_chooser"));
        this.addPage((IWizardPage)this.chooserPage);
        this.sourcePage = new DeploymentSource(Messages.getString("Deployment.deployment_wizard_source"));
        this.addPage((IWizardPage)this.sourcePage);
        this.targetPage = new DeploymentTarget(Messages.getString("Deployment.deployment_wizard_target"));
        this.addPage((IWizardPage)this.targetPage);
        this.descriptionPage = new DeploymentDescription(Messages.getString("Deployment.deployment_wizard_description"));
        this.addPage((IWizardPage)this.descriptionPage);
    }

    public boolean performFinish() {
        IGridElement[] iGridElementArray;
        IGridElement[] iGridElementArray2;
        Object[] objectArray = this.sourcePage.getSourceTree().getCheckedElements();
        ArrayList<IGridElement> arrayList = new ArrayList<IGridElement>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            iGridElementArray2 = objectArray2[n2];
            iGridElementArray = (IGridElement)iGridElementArray2;
            if (!this.sourcePage.getSourceTree().getChecked((Object)iGridElementArray.getParent())) {
                arrayList.add((IGridElement)iGridElementArray);
            }
            ++n2;
        }
        iGridElementArray2 = arrayList.toArray(new IGridElement[arrayList.size()]);
        ArrayList<IGridElement> arrayList2 = new ArrayList<IGridElement>();
        Object[] objectArray3 = this.targetPage.getCETree().getCheckedElements();
        objectArray2 = this.targetPage.getSETree().getCheckedElements();
        Object object = objectArray3;
        int n3 = objectArray3.length;
        int n4 = 0;
        while (n4 < n3) {
            iGridElementArray = object[n4];
            arrayList2.add((IGridElement)iGridElementArray);
            ++n4;
        }
        object = objectArray2;
        n3 = objectArray2.length;
        n4 = 0;
        while (n4 < n3) {
            iGridElementArray = object[n4];
            arrayList2.add((IGridElement)iGridElementArray);
            ++n4;
        }
        iGridElementArray = arrayList2.toArray(new IGridElement[arrayList2.size()]);
        String string = this.descriptionPage.getTag();
        IApplicationDeployment iApplicationDeployment = this.chooserPage.getExecuteExt();
        object = new DeploymentJob(Messages.getString("Deployment.deployment_wizard_job"), iApplicationDeployment, iGridElementArray2, iGridElementArray, string);
        object.setPriority(20);
        object.schedule();
        return true;
    }

    public boolean canFinish() {
        boolean bl = false;
        IWizardPage iWizardPage = this.getContainer().getCurrentPage();
        if (iWizardPage == this.descriptionPage) {
            bl = true;
        }
        return bl;
    }

    protected void initProjects() {
        ArrayList<IGridElement> arrayList = new ArrayList<IGridElement>();
        IGridElement[] iGridElementArray = null;
        IProject[] iProjectArray = null;
        this.trueGridProject = (IGridElement)this.selection.getFirstElement();
        IProject iProject = (IProject)this.trueGridProject.getResource();
        try {
            iProjectArray = iProject.getReferencedProjects();
            IGridElement[] iGridElementArray2 = iGridElementArray = GridModel.getRoot().getChildren(null);
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement iGridElement = iGridElementArray2[n2];
                IProject[] iProjectArray2 = iProjectArray;
                int n3 = iProjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject iProject2 = iProjectArray2[n4];
                    if (iProject2.getName().equals(iGridElement.getName())) {
                        arrayList.add(iGridElement);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
        this.referencedProjects = arrayList.size() > 0 ? arrayList.toArray(new IGridElement[arrayList.size()]) : new IGridElement[0];
    }

    public IGridElement[] getReferencedProjects() {
        return this.referencedProjects;
    }

    public IGridElement getGridProject() {
        return this.trueGridProject;
    }
}

