/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.jobsubmission;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridJobCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobSubmissionService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.wizards.wizardselection.IInitalizableWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;

public abstract class JobSubmissionWizardBase
extends Wizard
implements IInitalizableWizard,
IExecutableExtension {
    protected IGridJobCreator creator;
    protected List<IGridJobDescription> jobDescriptions;

    protected JobSubmissionWizardBase() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        boolean bl = true;
        if (this.creator != null) {
            final IGridJobSubmissionService iGridJobSubmissionService = this.getSubmissionService();
            IWizardContainer iWizardContainer = this.getContainer();
            try {
                iWizardContainer.run(true, true, new IRunnableWithProgress(){

                    protected void testCanceled(IProgressMonitor iProgressMonitor) {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.beginTask("Submitting jobs...", JobSubmissionWizardBase.this.jobDescriptions.size());
                        for (IGridJobDescription iGridJobDescription : JobSubmissionWizardBase.this.jobDescriptions) {
                            this.testCanceled(iProgressMonitor);
                            iProgressMonitor.subTask(iGridJobDescription.getName());
                            if (!JobSubmissionWizardBase.this.creator.canCreate(iGridJobDescription)) continue;
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            subProgressMonitor.beginTask("Submitting job " + iGridJobDescription.getName(), 10);
                            try {
                                subProgressMonitor.subTask("Creating job file");
                                IGridContainer iGridContainer = JobSubmissionWizardBase.this.buildPath(iGridJobDescription);
                                subProgressMonitor.worked(1);
                                this.testCanceled((IProgressMonitor)subProgressMonitor);
                                IGridJobID iGridJobID = null;
                                if (iGridJobSubmissionService != null) {
                                    subProgressMonitor.subTask("Submission in progress");
                                    iGridJobID = iGridJobSubmissionService.submitJob(iGridJobDescription, (IProgressMonitor)subProgressMonitor);
                                    subProgressMonitor.worked(9);
                                    this.testCanceled((IProgressMonitor)subProgressMonitor);
                                } else {
                                    NewProblemDialog.openProblem(JobSubmissionWizardBase.this.getShell(), "Job submission failed", "Cannot find a Job Submission Service to submit job to.", null);
                                }
                                JobSubmissionWizardBase.this.creator.create(iGridContainer, iGridJobID);
                            }
                            catch (GridModelException gridModelException) {
                                NewProblemDialog.openProblem(JobSubmissionWizardBase.this.getShell(), "Job submission failed", null, gridModelException);
                                subProgressMonitor.done();
                                continue;
                            }
                            catch (CoreException coreException) {
                                try {
                                    NewProblemDialog.openProblem(JobSubmissionWizardBase.this.getShell(), "Job submission failed", null, coreException);
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    subProgressMonitor.done();
                                }
                            }
                            subProgressMonitor.done();
                        }
                        iProgressMonitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                NewProblemDialog.openProblem(this.getShell(), "Job submission failed", "Job submission failed", invocationTargetException.getCause());
                bl = false;
            }
            catch (InterruptedException interruptedException) {
                NewProblemDialog.openProblem(this.getShell(), "Job submission interrupted", "Job submission interrupted", interruptedException);
                bl = false;
            }
        }
        return bl;
    }

    protected abstract IGridJobSubmissionService getSubmissionService();

    private IGridContainer buildPath(IGridJobDescription iGridJobDescription) throws CoreException {
        IGridContainer iGridContainer = null;
        IPath iPath = iGridJobDescription.getPath().removeLastSegments(1);
        IPath iPath2 = iGridJobDescription.getProject().getPath();
        iPath = iPath.removeFirstSegments(iPath2.segmentCount());
        IPath iPath3 = iPath2.append(IGridProject.DIR_JOBS);
        if (IGridProject.DIR_JOBDESCRIPTIONS.equals(iPath.segment(0))) {
            iPath3 = iPath3.append(iPath.removeFirstSegments(1));
        }
        IWorkspaceRoot iWorkspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
        IFolder iFolder = iWorkspaceRoot.getFolder(iPath3);
        this.createFolder(iFolder);
        iGridContainer = (IGridContainer)GridModel.getRoot().findElement((IResource)iFolder);
        return iGridContainer;
    }

    private void createFolder(IFolder iFolder) throws CoreException {
        IContainer iContainer = iFolder.getParent();
        if (iContainer != null && iContainer instanceof IFolder) {
            this.createFolder((IFolder)iContainer);
        }
        if (!iFolder.exists()) {
            iFolder.create(true, true, null);
        }
    }

    public boolean init(Object object) {
        boolean bl = false;
        if (object instanceof List) {
            this.jobDescriptions = (List)object;
            bl = true;
        }
        return bl;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iConfigurationElement.getDeclaringExtension().getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
            if ("job_creator".equals(iConfigurationElement2.getName())) {
                Object object2 = iConfigurationElement2.createExecutableExtension("class");
                if (!(object2 instanceof IGridJobCreator)) {
                    Status status = new Status(4, "eu.geclipse.ui", 0, "Job Creator configured in class atribute for job_creator element in eu.geclipse.ou.jobSubmissionWizzard is not implementing IGridJobCreator interface", null);
                    throw new CoreException((IStatus)status);
                }
                this.creator = (IGridJobCreator)object2;
            }
            ++n2;
        }
    }
}

