/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.portforward;

import eu.geclipse.ui.wizards.portforward.IForwardTableEntry;
import eu.geclipse.ui.wizards.portforward.Messages;
import eu.geclipse.ui.wizards.portforward.NewPortForwardComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class NewPortForwardDialog
extends TitleAreaDialog
implements Listener {
    private NewPortForwardComposite composite;
    private IForwardTableEntry forward;

    protected NewPortForwardDialog(Shell shell) {
        super(shell);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getString("NewPortForwardDialog.title"));
        this.getShell().setText(Messages.getString("NewPortForwardDialog.title"));
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite composite) {
        this.composite = new NewPortForwardComposite(composite, 0, this);
        this.composite.setLayoutData(new GridData(1808));
        return this.composite;
    }

    public void handleEvent(Event event) {
        this.validateInput();
    }

    private void validateInput() {
        IStatus iStatus = this.composite.getStatus();
        this.applyToStatusLine(iStatus);
        this.getButton(0).setEnabled(iStatus.getSeverity() != 4);
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (string.length() == 0) {
            string = null;
        }
        switch (iStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(string);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(string, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(string, 1);
                break;
            }
            default: {
                this.setErrorMessage(string);
                this.setMessage(null);
            }
        }
    }

    protected void okPressed() {
        this.forward = this.composite.getForward();
        super.okPressed();
    }

    IForwardTableEntry getForward() {
        return this.forward;
    }
}

