/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

class WizardSelectionListComposite
extends Composite {
    private Table table = null;
    private TableViewer tableViewer;

    WizardSelectionListComposite(Composite composite, int n) {
        super(composite, n);
        this.initialize();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                String string = object instanceof IWizardSelectionNode ? ((IWizardSelectionNode)object).getName() : object.toString();
                return string;
            }

            public Image getImage(Object object) {
                Image image = null;
                if (object instanceof IWizardSelectionNode) {
                    image = ((IWizardSelectionNode)object).getIcon();
                }
                return image;
            }
        });
    }

    void addSelectionListener(SelectionListener selectionListener) {
        this.table.addSelectionListener(selectionListener);
    }

    void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.table = new Table((Composite)this, 2048);
        this.table.setLayoutData((Object)gridData);
        this.setSize(new Point(300, 200));
        this.setLayout((Layout)new GridLayout());
    }

    void fillWizardList(IWizardSelectionNode[] iWizardSelectionNodeArray) {
        this.tableViewer.add((Object[])iWizardSelectionNodeArray);
    }
}

