/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.wizards.wizardselection.IInitalizableWizard;
import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import eu.geclipse.ui.wizards.wizardselection.WizardSelectionListComposite;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class WizardSelectionListPage
extends WizardSelectionPage
implements IPageChangedListener {
    protected ICheatSheetManager cheatSheetManager = null;
    protected IWizardSelectionNode[] wizardSelectionNodes;
    IWizardNode preselectedNode;
    private String title;
    private String desc;
    private WizardSelectionListComposite composite;
    private Object initData;
    private boolean hidePrev;

    public WizardSelectionListPage(String string, IWizardSelectionNode[] iWizardSelectionNodeArray, String string2, String string3, String string4) {
        super(string);
        this.wizardSelectionNodes = iWizardSelectionNodeArray;
        this.title = string2;
        this.desc = string3;
        if (iWizardSelectionNodeArray.length == 1) {
            this.preselectedNode = iWizardSelectionNodeArray[0];
        } else if (iWizardSelectionNodeArray.length == 0) {
            this.setErrorMessage(string4);
        }
    }

    public void setInitData(Object object) {
        this.initData = object;
    }

    public void setPreselectedNode(IWizardNode iWizardNode, boolean bl) {
        this.preselectedNode = iWizardNode;
        this.hidePrev = bl;
    }

    public void dispose() {
        IWizardSelectionNode[] iWizardSelectionNodeArray = this.wizardSelectionNodes;
        int n = this.wizardSelectionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardSelectionNode iWizardSelectionNode = iWizardSelectionNodeArray[n2];
            iWizardSelectionNode.dispose();
            ++n2;
        }
        super.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.desc;
    }

    public void createControl(Composite composite) {
        ((WizardDialog)this.getContainer()).addPageChangedListener((IPageChangedListener)this);
        this.composite = new WizardSelectionListComposite(composite, 0);
        this.setControl((Control)this.composite);
        this.composite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Object object = ((StructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                if (object instanceof IWizardNode) {
                    WizardSelectionListPage.this.setSelectedNode((IWizardNode)object);
                }
                WizardSelectionListPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.composite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                WizardSelectionListPage.this.getWizard().getContainer().showPage(WizardSelectionListPage.this.getNextPage());
            }
        });
        this.composite.fillWizardList(this.wizardSelectionNodes);
    }

    private IWizard initWizard(IWizardNode iWizardNode) {
        IWizard iWizard = null;
        if (iWizardNode != null) {
            boolean bl = iWizardNode.isContentCreated();
            iWizard = iWizardNode.getWizard();
            if (iWizard != null && !bl) {
                if (iWizard instanceof IInitalizableWizard) {
                    ((IInitalizableWizard)iWizard).init(this.initData);
                }
                iWizard.addPages();
                if (this.cheatSheetManager != null && this.cheatSheetManager.getData("startingPageName") == "none") {
                    this.cheatSheetManager.setData("startingPageName", iWizard.getStartingPage().getName());
                }
            }
        }
        return iWizard;
    }

    public IWizardPage getNextPage() {
        this.initWizard(this.getSelectedNode());
        return super.getNextPage();
    }

    public void pageChanged(final PageChangedEvent pageChangedEvent) {
        ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (WizardSelectionListPage.this.preselectedNode != null && pageChangedEvent.getSelectedPage() == WizardSelectionListPage.this) {
                    WizardSelectionListPage.this.setSelectedNode(WizardSelectionListPage.this.preselectedNode);
                    WizardSelectionListPage.this.getContainer().showPage(WizardSelectionListPage.this.getNextPage());
                    if (WizardSelectionListPage.this.hidePrev) {
                        WizardSelectionListPage.this.getContainer().getCurrentPage().setPreviousPage(null);
                    }
                    WizardSelectionListPage.this.getContainer().updateButtons();
                }
            }
        });
    }

    public void setCheatSheetManager(ICheatSheetManager iCheatSheetManager) {
        this.cheatSheetManager = iCheatSheetManager;
    }
}

