/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.commands;

import eu.geclipse.workflow.IInputPort;
import eu.geclipse.workflow.ILink;
import eu.geclipse.workflow.IOutputPort;
import eu.geclipse.workflow.IWorkflow;
import eu.geclipse.workflow.ui.edit.policies.WorkflowBaseItemSemanticEditPolicy;
import eu.geclipse.workflow.ui.part.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class LinkReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public LinkReorientCommand(ReorientRelationshipRequest reorientRelationshipRequest) {
        super(reorientRelationshipRequest.getLabel(), reorientRelationshipRequest.getRelationship(), (IEditCommandRequest)reorientRelationshipRequest);
        this.reorientDirection = reorientRelationshipRequest.getDirection();
        this.oldEnd = reorientRelationshipRequest.getOldRelationshipEnd();
        this.newEnd = reorientRelationshipRequest.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ILink)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof IOutputPort) || !(this.newEnd instanceof IOutputPort)) {
            return false;
        }
        IInputPort iInputPort = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof IWorkflow)) {
            return false;
        }
        IWorkflow iWorkflow = (IWorkflow)this.getLink().eContainer();
        return WorkflowBaseItemSemanticEditPolicy.LinkConstraints.canExistILink_3001(iWorkflow, this.getNewSource(), iInputPort);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof IInputPort) || !(this.newEnd instanceof IInputPort)) {
            return false;
        }
        IOutputPort iOutputPort = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof IWorkflow)) {
            return false;
        }
        IWorkflow iWorkflow = (IWorkflow)this.getLink().eContainer();
        return WorkflowBaseItemSemanticEditPolicy.LinkConstraints.canExistILink_3001(iWorkflow, iOutputPort, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException(Messages.getString("LinkCreateCommand_InvalidArgumentsInReorientLink"));
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ILink getLink() {
        return (ILink)this.getElementToEdit();
    }

    protected IOutputPort getOldSource() {
        return (IOutputPort)this.oldEnd;
    }

    protected IOutputPort getNewSource() {
        return (IOutputPort)this.newEnd;
    }

    protected IInputPort getOldTarget() {
        return (IInputPort)this.oldEnd;
    }

    protected IInputPort getNewTarget() {
        return (IInputPort)this.newEnd;
    }
}

