/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.editor;

import eu.geclipse.workflow.IWorkflow;
import eu.geclipse.workflow.IWorkflowFactory;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.part.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowDiagramEditorUtil {
    public static Map getSaveOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ENCODING", "UTF-8");
        hashMap.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return hashMap;
    }

    public static boolean openDiagram(Resource resource) throws PartInitException {
        String string = resource.getURI().toPlatformString(true);
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string));
        if (iResource instanceof IFile) {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput((IFile)iResource), "eu.geclipse.workflow.ui.part.WorkflowDiagramEditorID") != null;
        }
        return false;
    }

    public static void setCharset(IFile iFile) {
        if (iFile == null) {
            return;
        }
        try {
            iFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            WorkflowDiagramEditorPlugin.getInstance().logError("Unable to set charset for file " + iFile.getFullPath(), coreException);
        }
    }

    public static String getUniqueFileName(IPath iPath, String string, String string2) {
        if (iPath == null) {
            iPath = new Path("");
        }
        if (string == null || string.trim().length() == 0) {
            string = "default";
        }
        IPath iPath2 = iPath.append(string);
        if (string2 != null && !string2.equals(iPath2.getFileExtension())) {
            iPath2 = iPath2.addFileExtension(string2);
        }
        string2 = iPath2.getFileExtension();
        string = iPath2.removeFileExtension().lastSegment();
        int n = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(iPath2)) {
            iPath2 = iPath.append(String.valueOf(string) + ++n);
            if (string2 == null) continue;
            iPath2 = iPath2.addFileExtension(string2);
        }
        return iPath2.lastSegment();
    }

    public static void runWizard(Shell shell, Wizard wizard, String string) {
        IDialogSettings iDialogSettings = WorkflowDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        wizard.setDialogSettings(iDialogSettings2);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(Math.max(500, wizardDialog.getShell().getSize().x), 500);
        wizardDialog.open();
    }

    public static Resource createDiagram(URI uRI, IProgressMonitor iProgressMonitor) {
        TransactionalEditingDomain transactionalEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        iProgressMonitor.beginTask(Messages.getString("WorkflowDiagramEditorUtil_CreateDiagramProgressTask"), 3);
        final Resource resource = transactionalEditingDomain.getResourceSet().createResource(uRI);
        final String string = uRI.lastSegment();
        AbstractTransactionalCommand abstractTransactionalCommand = new AbstractTransactionalCommand(transactionalEditingDomain, Messages.getString("WorkflowDiagramEditorUtil_CreateDiagramCommandLabel"), Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                IWorkflow iWorkflow = WorkflowDiagramEditorUtil.createInitialModel();
                WorkflowDiagramEditorUtil.attachModelToResource(iWorkflow, resource);
                Diagram diagram = ViewService.createDiagram((EObject)iWorkflow, (String)"Workflow", (PreferencesHint)WorkflowDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    resource.getContents().add((Object)diagram);
                    diagram.setName(string);
                    diagram.setElement((EObject)iWorkflow);
                }
                try {
                    resource.save(WorkflowDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException iOException) {
                    WorkflowDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", iOException);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)abstractTransactionalCommand, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), null);
        }
        catch (ExecutionException executionException) {
            WorkflowDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", executionException);
        }
        WorkflowDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)resource));
        return resource;
    }

    private static IWorkflow createInitialModel() {
        return IWorkflowFactory.eINSTANCE.createIWorkflow();
    }

    private static void attachModelToResource(IWorkflow iWorkflow, Resource resource) {
        resource.getContents().add((Object)iWorkflow);
    }

    public static void selectElementsInDiagram(IDiagramWorkbenchPart iDiagramWorkbenchPart, List list) {
        iDiagramWorkbenchPart.getDiagramGraphicalViewer().deselectAll();
        EditPart editPart = null;
        for (EditPart editPart2 : list) {
            iDiagramWorkbenchPart.getDiagramGraphicalViewer().appendSelection(editPart2);
            if (editPart != null || !(editPart2 instanceof IPrimaryEditPart)) continue;
            editPart = editPart2;
        }
        if (!list.isEmpty()) {
            iDiagramWorkbenchPart.getDiagramGraphicalViewer().reveal(editPart != null ? editPart : (EditPart)list.get(0));
        }
    }

    private static int findElementsInDiagramByID(DiagramEditPart diagramEditPart, EObject eObject, List list) {
        String string;
        IDiagramGraphicalViewer iDiagramGraphicalViewer = (IDiagramGraphicalViewer)diagramEditPart.getViewer();
        int n = list.size();
        if (eObject instanceof View && (string = (EditPart)iDiagramGraphicalViewer.getEditPartRegistry().get(eObject)) != null) {
            list.add(string);
            return 1;
        }
        string = EMFCoreUtil.getProxyID((EObject)eObject);
        List list2 = iDiagramGraphicalViewer.findEditPartsForElement(string, IGraphicalEditPart.class);
        for (EditPart editPart : list2) {
            EditPart editPart2 = editPart.getParent();
            while (editPart2 != null && !list2.contains(editPart2)) {
                editPart2 = editPart2.getParent();
            }
            if (editPart2 != null) continue;
            list.add(editPart);
        }
        if (n == list.size()) {
            if (!list2.isEmpty()) {
                list.add(list2.iterator().next());
            } else if (eObject.eContainer() != null) {
                return WorkflowDiagramEditorUtil.findElementsInDiagramByID(diagramEditPart, eObject.eContainer(), list);
            }
        }
        return list.size() - n;
    }

    public static View findView(DiagramEditPart diagramEditPart, EObject eObject, LazyElement2ViewMap lazyElement2ViewMap) {
        boolean bl = false;
        if (eObject.eResource() instanceof XMLResource) {
            bl = ((XMLResource)eObject.eResource()).getID(eObject) == null;
        }
        View view = null;
        if (bl && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {
            view = (View)lazyElement2ViewMap.getElement2ViewMap().get(eObject);
        } else if (WorkflowDiagramEditorUtil.findElementsInDiagramByID(diagramEditPart, eObject, lazyElement2ViewMap.editPartTmpHolder) > 0) {
            EditPart editPart = (EditPart)lazyElement2ViewMap.editPartTmpHolder.get(0);
            lazyElement2ViewMap.editPartTmpHolder.clear();
            view = editPart.getModel() instanceof View ? (View)editPart.getModel() : null;
        }
        return view == null ? diagramEditPart.getDiagramView() : view;
    }

    public static class LazyElement2ViewMap {
        private Map element2ViewMap;
        private View scope;
        private Set elementSet;
        public final List editPartTmpHolder = new ArrayList();

        public LazyElement2ViewMap(View view, Set set) {
            this.scope = view;
            this.elementSet = set;
        }

        public final Map getElement2ViewMap() {
            if (this.element2ViewMap == null) {
                this.element2ViewMap = new HashMap();
                for (EObject eObject : this.elementSet) {
                    View view;
                    if (!(eObject instanceof View) || (view = (View)eObject).getDiagram() != this.scope.getDiagram()) continue;
                    this.element2ViewMap.put(eObject, eObject);
                }
                LazyElement2ViewMap.buildElement2ViewMap(this.scope, this.element2ViewMap, this.elementSet);
            }
            return this.element2ViewMap;
        }

        static Map buildElement2ViewMap(View view, Map map, Set set) {
            if (set.size() == map.size()) {
                return map;
            }
            if (view.isSetElement() && !map.containsKey(view.getElement()) && set.contains(view.getElement())) {
                map.put(view.getElement(), view);
                if (set.size() == map.size()) {
                    return map;
                }
            }
            Iterator iterator = view.getChildren().iterator();
            while (iterator.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)iterator.next(), map, set);
                if (set.size() != map.size()) continue;
                return map;
            }
            iterator = view.getSourceEdges().iterator();
            while (iterator.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)iterator.next(), map, set);
                if (set.size() != map.size()) continue;
                return map;
            }
            iterator = view.getSourceEdges().iterator();
            while (iterator.hasNext()) {
                LazyElement2ViewMap.buildElement2ViewMap((View)iterator.next(), map, set);
                if (set.size() != map.size()) continue;
                return map;
            }
            return map;
        }
    }
}

