/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.internal;

import eu.geclipse.workflow.provider.WorkflowItemProviderAdapterFactory;
import eu.geclipse.workflow.ui.part.WorkflowDocumentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WorkflowDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "eu.geclipse.workflow.ui";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("eu.geclipse.workflow.ui");
    private static WorkflowDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private WorkflowDocumentProvider myDocumentProvider;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        instance = null;
        super.stop(bundleContext);
    }

    public static WorkflowDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList arrayList = new ArrayList();
        this.fillItemProviderFactories(arrayList);
        return new ComposedAdapterFactory(arrayList);
    }

    protected void fillItemProviderFactories(List list) {
        list.add(new WorkflowItemProviderAdapterFactory());
        list.add(new ResourceItemProviderAdapterFactory());
        list.add(new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object object) {
        IItemLabelProvider iItemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
        if (iItemLabelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(iItemLabelProvider.getImage(object));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)string);
    }

    public static ImageDescriptor findImageDescriptor(String string) {
        Path path = new Path(string);
        if (path.isAbsolute() && path.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)path.segment(0), (String)path.removeFirstSegments(1).makeAbsolute().toString());
        }
        return WorkflowDiagramEditorPlugin.getBundledImageDescriptor(path.makeAbsolute().toString());
    }

    public static String getString(String string) {
        return Platform.getResourceString((Bundle)WorkflowDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + string));
    }

    public Image getBundledImage(String string) {
        Image image = this.getImageRegistry().get(string);
        if (image == null) {
            this.getImageRegistry().put(string, WorkflowDiagramEditorPlugin.getBundledImageDescriptor(string));
            image = this.getImageRegistry().get(string);
        }
        return image;
    }

    public WorkflowDocumentProvider getDocumentProvider() {
        if (this.myDocumentProvider == null) {
            this.myDocumentProvider = new WorkflowDocumentProvider();
        }
        return this.myDocumentProvider;
    }

    public void logError(String string) {
        this.logError(string, null);
    }

    public void logError(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, string, throwable));
    }

    public void logInfo(String string) {
        this.logInfo(string, null);
    }

    public void logInfo(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, string, throwable));
    }
}

