/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.navigator;

import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.navigator.WorkflowAbstractNavigatorItem;
import eu.geclipse.workflow.ui.navigator.WorkflowDomainNavigatorItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WorkflowDomainNavigatorContentProvider
implements ICommonContentProvider {
    private AdapterFactoryContentProvider myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(WorkflowDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public WorkflowDomainNavigatorContentProvider() {
        TransactionalEditingDomain transactionalEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)transactionalEditingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object object) {
                if (!this.containsKey(object)) {
                    this.put(object, Boolean.TRUE);
                }
                return super.get(object);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (WorkflowDomainNavigatorContentProvider.this.myViewer != null) {
                    WorkflowDomainNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(transactionalEditingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource resource2 : WorkflowDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowDomainNavigatorContentProvider.this.myViewer != null) {
                    WorkflowDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource resource2 : WorkflowDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowDomainNavigatorContentProvider.this.myViewer != null) {
                    WorkflowDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI uRI) {
                for (Resource resource2 : WorkflowDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowDomainNavigatorContentProvider.this.myViewer != null) {
                    WorkflowDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void restoreState(IMemento iMemento) {
    }

    public void saveState(IMemento iMemento) {
    }

    public void init(ICommonContentExtensionSite iCommonContentExtensionSite) {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(uRI, true);
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)resource), object);
        }
        if (object instanceof WorkflowDomainNavigatorItem) {
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)((WorkflowDomainNavigatorItem)((Object)object)).getEObject()), object);
        }
        return EMPTY_ARRAY;
    }

    public Object[] wrapEObjects(Object[] objectArray, Object object) {
        ArrayList<WorkflowDomainNavigatorItem> arrayList = new ArrayList<WorkflowDomainNavigatorItem>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EObject) {
                arrayList.add(new WorkflowDomainNavigatorItem((EObject)objectArray[n], object, (IPropertySourceProvider)this.myAdapterFctoryContentProvier));
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public Object getParent(Object object) {
        if (object instanceof WorkflowAbstractNavigatorItem) {
            WorkflowAbstractNavigatorItem workflowAbstractNavigatorItem = (WorkflowAbstractNavigatorItem)((Object)object);
            return workflowAbstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return object instanceof IFile || this.getChildren(object).length > 0;
    }
}

