/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.navigator;

import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorItem;
import eu.geclipse.workflow.ui.part.WorkflowVisualIDRegistry;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowNavigatorActionProvider
extends CommonActionProvider {
    private boolean myContribute;
    private OpenDiagramAction myOpenDiagramAction;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        super.init(iCommonActionExtensionSite);
        if (iCommonActionExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.myContribute = true;
            this.makeActions((ICommonViewerWorkbenchSite)iCommonActionExtensionSite.getViewSite());
        } else {
            this.myContribute = false;
        }
    }

    private void makeActions(ICommonViewerWorkbenchSite iCommonViewerWorkbenchSite) {
        this.myOpenDiagramAction = new OpenDiagramAction(iCommonViewerWorkbenchSite);
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (!this.myContribute) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.myOpenDiagramAction.selectionChanged(iStructuredSelection);
        if (this.myOpenDiagramAction.isEnabled()) {
            iActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.myOpenDiagramAction);
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
    }

    private class OpenDiagramAction
    extends Action {
        private Diagram myDiagram;
        private ICommonViewerWorkbenchSite myViewerSite;

        public OpenDiagramAction(ICommonViewerWorkbenchSite iCommonViewerWorkbenchSite) {
            super("Open Diagram");
            this.myViewerSite = iCommonViewerWorkbenchSite;
        }

        public final void selectionChanged(IStructuredSelection iStructuredSelection) {
            this.myDiagram = null;
            if (iStructuredSelection.size() == 1) {
                Diagram diagram;
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof WorkflowNavigatorItem) {
                    object = ((WorkflowNavigatorItem)((Object)object)).getView();
                } else if (object instanceof IAdaptable) {
                    object = ((IAdaptable)object).getAdapter(View.class);
                }
                if (object instanceof Diagram && "Workflow".equals(WorkflowVisualIDRegistry.getModelID((View)(diagram = (Diagram)object)))) {
                    this.myDiagram = diagram;
                }
            }
            this.setEnabled(this.myDiagram != null);
        }

        public void run() {
            if (this.myDiagram == null || this.myDiagram.eResource() == null) {
                return;
            }
            IEditorInput iEditorInput = this.getEditorInput();
            IWorkbenchPage iWorkbenchPage = this.myViewerSite.getPage();
            try {
                iWorkbenchPage.openEditor(iEditorInput, "eu.geclipse.workflow.ui.part.WorkflowDiagramEditorID");
            }
            catch (PartInitException partInitException) {
                WorkflowDiagramEditorPlugin.getInstance().logError("Exception while openning diagram", partInitException);
            }
        }

        private IEditorInput getEditorInput() {
            Resource resource = this.myDiagram.eResource();
            for (EObject eObject : resource.getContents()) {
                if (eObject == this.myDiagram) {
                    return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)resource));
                }
                if (eObject instanceof Diagram) break;
            }
            return new URIEditorInput(resource.getURI().appendFragment(resource.getURIFragment((EObject)this.myDiagram)));
        }
    }
}

