/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.navigator;

import eu.geclipse.workflow.ui.navigator.WorkflowAbstractNavigatorItem;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorGroup;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorItem;
import eu.geclipse.workflow.ui.part.Messages;
import eu.geclipse.workflow.ui.part.WorkflowVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class WorkflowNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public WorkflowNavigatorContentProvider() {
        TransactionalEditingDomain transactionalEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)transactionalEditingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object object) {
                if (!this.containsKey(object)) {
                    this.put(object, Boolean.TRUE);
                }
                return super.get(object);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (WorkflowNavigatorContentProvider.this.myViewer != null) {
                    WorkflowNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(transactionalEditingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource resource2 : WorkflowNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowNavigatorContentProvider.this.myViewer != null) {
                    WorkflowNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource resource2 : WorkflowNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowNavigatorContentProvider.this.myViewer != null) {
                    WorkflowNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI uRI) {
                for (Resource resource2 : WorkflowNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    resource2.unload();
                }
                if (WorkflowNavigatorContentProvider.this.myViewer != null) {
                    WorkflowNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(WorkflowNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void restoreState(IMemento iMemento) {
    }

    public void saveState(IMemento iMemento) {
    }

    public void init(ICommonContentExtensionSite iCommonContentExtensionSite) {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(uRI, true);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Workflow"), iFile, false));
            return arrayList.toArray();
        }
        if (object instanceof WorkflowNavigatorGroup) {
            WorkflowNavigatorGroup workflowNavigatorGroup = (WorkflowNavigatorGroup)((Object)object);
            return workflowNavigatorGroup.getChildren();
        }
        if (object instanceof WorkflowNavigatorItem) {
            WorkflowNavigatorItem workflowNavigatorItem = (WorkflowNavigatorItem)((Object)object);
            if (workflowNavigatorItem.isLeaf() || !this.isOwnView(workflowNavigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(workflowNavigatorItem.getView(), object);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object object) {
        switch (WorkflowVisualIDRegistry.getVisualID(view)) {
            case 79: {
                ArrayList<WorkflowNavigatorGroup> arrayList = new ArrayList<WorkflowNavigatorGroup>();
                WorkflowNavigatorGroup workflowNavigatorGroup = new WorkflowNavigatorGroup(Messages.getString("NavigatorGroupName_IWorkflow_79_links"), "icons/obj16/LinksNavigatorGroup.gif", object);
                Collection collection = this.getChildrenByType(Collections.singleton(view), 1001);
                arrayList.addAll(this.createNavigatorItems(collection, object, false));
                collection = this.getDiagramLinksByType(Collections.singleton(view), 3001);
                workflowNavigatorGroup.addChildren(this.createNavigatorItems(collection, (Object)workflowNavigatorGroup, false));
                if (!workflowNavigatorGroup.isEmpty()) {
                    arrayList.add(workflowNavigatorGroup);
                }
                return arrayList.toArray();
            }
            case 1001: {
                ArrayList arrayList = new ArrayList();
                Collection collection = this.getChildrenByType(Collections.singleton(view), 2001);
                arrayList.addAll(this.createNavigatorItems(collection, object, false));
                collection = this.getChildrenByType(Collections.singleton(view), 2002);
                arrayList.addAll(this.createNavigatorItems(collection, object, false));
                return arrayList.toArray();
            }
            case 2001: {
                ArrayList<WorkflowNavigatorGroup> arrayList = new ArrayList<WorkflowNavigatorGroup>();
                WorkflowNavigatorGroup workflowNavigatorGroup = new WorkflowNavigatorGroup(Messages.getString("NavigatorGroupName_IOutputPort_2001_outgoinglinks"), "icons/obj16/OutputLinks.gif", object);
                Collection collection = this.getOutgoingLinksByType(Collections.singleton(view), 3001);
                workflowNavigatorGroup.addChildren(this.createNavigatorItems(collection, (Object)workflowNavigatorGroup, true));
                if (!workflowNavigatorGroup.isEmpty()) {
                    arrayList.add(workflowNavigatorGroup);
                }
                return arrayList.toArray();
            }
            case 2002: {
                ArrayList<WorkflowNavigatorGroup> arrayList = new ArrayList<WorkflowNavigatorGroup>();
                WorkflowNavigatorGroup workflowNavigatorGroup = new WorkflowNavigatorGroup(Messages.getString("NavigatorGroupName_IInputPort_2002_incominglinks"), "icons/obj16/InputLinks.gif", object);
                Collection collection = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                workflowNavigatorGroup.addChildren(this.createNavigatorItems(collection, (Object)workflowNavigatorGroup, true));
                if (!workflowNavigatorGroup.isEmpty()) {
                    arrayList.add(workflowNavigatorGroup);
                }
                return arrayList.toArray();
            }
            case 3001: {
                ArrayList<WorkflowNavigatorGroup> arrayList = new ArrayList<WorkflowNavigatorGroup>();
                WorkflowNavigatorGroup workflowNavigatorGroup = new WorkflowNavigatorGroup(Messages.getString("NavigatorGroupName_ILink_3001_target"), "icons/obj16/LinkTarget.gif", object);
                WorkflowNavigatorGroup workflowNavigatorGroup2 = new WorkflowNavigatorGroup(Messages.getString("NavigatorGroupName_ILink_3001_source"), "icons/obj16/LinkSource.gif", object);
                Collection collection = this.getLinksTargetByType(Collections.singleton(view), 2002);
                workflowNavigatorGroup.addChildren(this.createNavigatorItems(collection, (Object)workflowNavigatorGroup, true));
                collection = this.getLinksSourceByType(Collections.singleton(view), 2001);
                workflowNavigatorGroup2.addChildren(this.createNavigatorItems(collection, (Object)workflowNavigatorGroup2, true));
                if (!workflowNavigatorGroup.isEmpty()) {
                    arrayList.add(workflowNavigatorGroup);
                }
                if (!workflowNavigatorGroup2.isEmpty()) {
                    arrayList.add(workflowNavigatorGroup2);
                }
                return arrayList.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection collection, int n) {
        ArrayList<View> arrayList = new ArrayList<View>();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (Edge edge : collection) {
            View view = edge.getSource();
            if (!string.equals(view.getType()) || !this.isOwnView(view)) continue;
            arrayList.add(view);
        }
        return arrayList;
    }

    private Collection getLinksTargetByType(Collection collection, int n) {
        ArrayList<View> arrayList = new ArrayList<View>();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (Edge edge : collection) {
            View view = edge.getTarget();
            if (!string.equals(view.getType()) || !this.isOwnView(view)) continue;
            arrayList.add(view);
        }
        return arrayList;
    }

    private Collection getOutgoingLinksByType(Collection collection, int n) {
        ArrayList arrayList = new ArrayList();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (View view : collection) {
            arrayList.addAll(this.selectViewsByType((Collection)view.getSourceEdges(), string));
        }
        return arrayList;
    }

    private Collection getIncomingLinksByType(Collection collection, int n) {
        ArrayList arrayList = new ArrayList();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (View view : collection) {
            arrayList.addAll(this.selectViewsByType((Collection)view.getTargetEdges(), string));
        }
        return arrayList;
    }

    private Collection getChildrenByType(Collection collection, int n) {
        ArrayList arrayList = new ArrayList();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (View view : collection) {
            arrayList.addAll(this.selectViewsByType((Collection)view.getChildren(), string));
        }
        return arrayList;
    }

    private Collection getDiagramLinksByType(Collection collection, int n) {
        ArrayList arrayList = new ArrayList();
        String string = WorkflowVisualIDRegistry.getType(n);
        for (Diagram diagram : collection) {
            arrayList.addAll(this.selectViewsByType((Collection)diagram.getEdges(), string));
        }
        return arrayList;
    }

    private Collection selectViewsByType(Collection collection, String string) {
        ArrayList<View> arrayList = new ArrayList<View>();
        for (View view : collection) {
            if (!string.equals(view.getType()) || !this.isOwnView(view)) continue;
            arrayList.add(view);
        }
        return arrayList;
    }

    private boolean isOwnView(View view) {
        return "Workflow".equals(WorkflowVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection collection, Object object, boolean bl) {
        ArrayList<WorkflowNavigatorItem> arrayList = new ArrayList<WorkflowNavigatorItem>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new WorkflowNavigatorItem((View)iterator.next(), object, bl));
        }
        return arrayList;
    }

    public Object getParent(Object object) {
        if (object instanceof WorkflowAbstractNavigatorItem) {
            WorkflowAbstractNavigatorItem workflowAbstractNavigatorItem = (WorkflowAbstractNavigatorItem)((Object)object);
            return workflowAbstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return object instanceof IFile || this.getChildren(object).length > 0;
    }
}

