/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.navigator;

import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.navigator.WorkflowAbstractNavigatorItem;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorGroup;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowNavigatorLinkHelper
implements ILinkHelper {
    private static IEditorInput getEditorInput(Diagram diagram) {
        Resource resource = diagram.eResource();
        for (EObject eObject : resource.getContents()) {
            if (eObject == diagram) {
                return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)resource));
            }
            if (eObject instanceof Diagram) break;
        }
        return new URIEditorInput(EcoreUtil.getURI((EObject)diagram));
    }

    public IStructuredSelection findSelection(IEditorInput iEditorInput) {
        IDiagramDocument iDiagramDocument = WorkflowDiagramEditorPlugin.getInstance().getDocumentProvider().getDiagramDocument(iEditorInput);
        if (iDiagramDocument == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = iDiagramDocument.getDiagram();
        IFile iFile = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (iFile != null) {
            WorkflowNavigatorItem workflowNavigatorItem = new WorkflowNavigatorItem((View)diagram, iFile, false);
            return new StructuredSelection((Object)workflowNavigatorItem);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage iWorkbenchPage, IStructuredSelection iStructuredSelection) {
        WorkflowNavigatorGroup workflowNavigatorGroup;
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return;
        }
        if (!(iStructuredSelection.getFirstElement() instanceof WorkflowAbstractNavigatorItem)) {
            return;
        }
        WorkflowAbstractNavigatorItem workflowAbstractNavigatorItem = (WorkflowAbstractNavigatorItem)((Object)iStructuredSelection.getFirstElement());
        View view = null;
        if (workflowAbstractNavigatorItem instanceof WorkflowNavigatorItem) {
            view = ((WorkflowNavigatorItem)workflowAbstractNavigatorItem).getView();
        } else if (workflowAbstractNavigatorItem instanceof WorkflowNavigatorGroup && (workflowNavigatorGroup = (WorkflowNavigatorGroup)workflowAbstractNavigatorItem).getParent() instanceof WorkflowNavigatorItem) {
            view = ((WorkflowNavigatorItem)((Object)workflowNavigatorGroup.getParent())).getView();
        }
        if (view == null) {
            return;
        }
        workflowNavigatorGroup = WorkflowNavigatorLinkHelper.getEditorInput(view.getDiagram());
        IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)workflowNavigatorGroup);
        if (iEditorPart == null) {
            return;
        }
        iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
        if (iEditorPart instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)iEditorPart;
            ResourceSet resourceSet = diagramEditor.getEditingDomain().getResourceSet();
            EObject eObject = resourceSet.getEObject(EcoreUtil.getURI((EObject)view), true);
            if (eObject == null) {
                return;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            EditPart editPart = (EditPart)graphicalViewer.getEditPartRegistry().get(eObject);
            if (editPart != null) {
                graphicalViewer.select(editPart);
            }
        }
    }
}

