/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.parsers;

import java.util.Arrays;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;

public abstract class AbstractParser
implements IParser {
    protected final EAttribute[] features;
    private String viewPattern;
    private String editorPattern;
    private String editPattern;

    public AbstractParser(EAttribute[] eAttributeArray) {
        if (eAttributeArray == null || eAttributeArray.length == 0 || Arrays.asList(eAttributeArray).contains(null)) {
            throw new IllegalArgumentException(Arrays.toString(eAttributeArray));
        }
        this.features = eAttributeArray;
    }

    public String getViewPattern() {
        return this.viewPattern;
    }

    public void setViewPattern(String string) {
        this.viewPattern = string;
    }

    public String getEditorPattern() {
        return this.editorPattern;
    }

    public void setEditorPattern(String string) {
        this.editorPattern = string;
    }

    public String getEditPattern() {
        return this.editPattern;
    }

    public void setEditPattern(String string) {
        this.editPattern = string;
    }

    public boolean isAffectingEvent(Object object, int n) {
        if (object instanceof Notification) {
            return this.isAffectingFeature(((Notification)object).getFeature());
        }
        return false;
    }

    protected boolean isAffectingFeature(Object object) {
        int n = 0;
        while (n < this.features.length) {
            if (this.features[n] == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable iAdaptable) {
        return null;
    }

    protected Object[] getValues(EObject eObject) {
        Object[] objectArray = new Object[this.features.length];
        int n = 0;
        while (n < this.features.length) {
            objectArray[n] = this.getValue(eObject, this.features[n]);
            ++n;
        }
        return objectArray;
    }

    protected Object getValue(EObject eObject, EAttribute eAttribute) {
        Object object = eObject.eGet((EStructuralFeature)eAttribute);
        Class clazz = eAttribute.getEAttributeType().getInstanceClass();
        if (String.class.equals((Object)clazz) && object == null) {
            object = "";
        }
        return object;
    }

    protected ICommand getParseCommand(IAdaptable iAdaptable, Object[] objectArray, int n) {
        if (objectArray == null || this.validateNewValues(objectArray).getCode() != 0) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject eObject = (EObject)iAdaptable.getAdapter(EObject.class);
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        if (transactionalEditingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand compositeTransactionalCommand = new CompositeTransactionalCommand(transactionalEditingDomain, "Set Values");
        int n2 = 0;
        while (n2 < objectArray.length) {
            compositeTransactionalCommand.compose((IUndoableOperation)this.getModificationCommand(eObject, this.features[n2], objectArray[n2]));
            ++n2;
        }
        return compositeTransactionalCommand;
    }

    protected ICommand getModificationCommand(EObject eObject, EAttribute eAttribute, Object object) {
        if ((object = this.getValidNewValue(eAttribute, object)) instanceof InvalidValue) {
            return UnexecutableCommand.INSTANCE;
        }
        SetRequest setRequest = new SetRequest(eObject, (EStructuralFeature)eAttribute, object);
        return new SetValueCommand(setRequest);
    }

    protected IParserEditStatus validateNewValues(Object[] objectArray) {
        if (objectArray.length != this.features.length) {
            return ParserEditStatus.UNEDITABLE_STATUS;
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = this.getValidNewValue(this.features[n], objectArray[n]);
            if (object instanceof InvalidValue) {
                return new ParserEditStatus("eu.geclipse.workflow.ui", 1, object.toString());
            }
            ++n;
        }
        return ParserEditStatus.EDITABLE_STATUS;
    }

    protected Object getValidNewValue(EAttribute eAttribute, Object object) {
        EClassifier eClassifier = eAttribute.getEType();
        if (eClassifier instanceof EDataType) {
            Class clazz = eClassifier.getInstanceClass();
            if (Boolean.TYPE.equals(clazz)) {
                if (!(object instanceof Boolean)) {
                    object = object instanceof String ? Boolean.valueOf((String)object) : new InvalidValue("Value of type Boolean is expected");
                }
            } else if (Character.TYPE.equals(clazz)) {
                if (!(object instanceof Character)) {
                    String string;
                    object = object instanceof String ? ((string = (String)object).length() == 0 ? null : new Character(string.charAt(0))) : new InvalidValue("Value of type Character is expected");
                }
            } else if (Byte.TYPE.equals(clazz)) {
                if (!(object instanceof Byte)) {
                    if (object instanceof Number) {
                        object = new Byte(((Number)object).byteValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Byte.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Byte value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Byte is expected");
                    }
                }
            } else if (Short.TYPE.equals(clazz)) {
                if (!(object instanceof Short)) {
                    if (object instanceof Number) {
                        object = new Short(((Number)object).shortValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Short.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Short value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Short is expected");
                    }
                }
            } else if (Integer.TYPE.equals(clazz)) {
                if (!(object instanceof Integer)) {
                    if (object instanceof Number) {
                        object = new Integer(((Number)object).intValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Integer.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Integer value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Integer is expected");
                    }
                }
            } else if (Long.TYPE.equals(clazz)) {
                if (!(object instanceof Long)) {
                    if (object instanceof Number) {
                        object = new Long(((Number)object).longValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Long.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Long value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Long is expected");
                    }
                }
            } else if (Float.TYPE.equals(clazz)) {
                if (!(object instanceof Float)) {
                    if (object instanceof Number) {
                        object = new Float(((Number)object).floatValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Float.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Float value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Float is expected");
                    }
                }
            } else if (Double.TYPE.equals(clazz)) {
                if (!(object instanceof Double)) {
                    if (object instanceof Number) {
                        object = new Double(((Number)object).doubleValue());
                    } else if (object instanceof String) {
                        String string = (String)object;
                        if (string.length() == 0) {
                            object = null;
                        } else {
                            try {
                                object = Double.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = new InvalidValue("String value does not convert to Double value");
                            }
                        }
                    } else {
                        object = new InvalidValue("Value of type Double is expected");
                    }
                }
            } else if (eClassifier instanceof EEnum) {
                EEnumLiteral eEnumLiteral;
                object = object instanceof String ? ((eEnumLiteral = ((EEnum)eClassifier).getEEnumLiteralByLiteral((String)object)) == null ? new InvalidValue("Unknown literal: " + object) : eEnumLiteral.getInstance()) : new InvalidValue("Value of type String is expected");
            }
        }
        return object;
    }

    protected class InvalidValue {
        private String description;

        public InvalidValue(String string) {
            this.description = string;
        }

        public String toString() {
            return this.description;
        }
    }
}

