/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.parsers;

import eu.geclipse.workflow.ui.parsers.AbstractParser;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;

public class MessageFormatParser
extends AbstractParser {
    private String defaultPattern;
    private MessageFormat viewProcessor;
    private MessageFormat editorProcessor;
    private MessageFormat editProcessor;

    public MessageFormatParser(EAttribute[] eAttributeArray) {
        super(eAttributeArray);
    }

    protected String getDefaultPattern() {
        if (this.defaultPattern == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.features.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('{');
                stringBuffer.append(n);
                stringBuffer.append('}');
                ++n;
            }
            this.defaultPattern = stringBuffer.toString();
        }
        return this.defaultPattern;
    }

    public String getViewPattern() {
        String string = super.getViewPattern();
        return string != null ? string : this.getDefaultPattern();
    }

    public void setViewPattern(String string) {
        super.setViewPattern(string);
        this.viewProcessor = null;
    }

    protected MessageFormat createViewProcessor(String string) {
        return new MessageFormat(string);
    }

    protected MessageFormat getViewProcessor() {
        if (this.viewProcessor == null) {
            this.viewProcessor = this.createViewProcessor(this.getViewPattern());
        }
        return this.viewProcessor;
    }

    public String getEditorPattern() {
        String string = super.getEditorPattern();
        return string != null ? string : this.getDefaultPattern();
    }

    public void setEditorPattern(String string) {
        super.setEditorPattern(string);
        this.editorProcessor = null;
    }

    protected MessageFormat createEditorProcessor(String string) {
        return new MessageFormat(string);
    }

    protected MessageFormat getEditorProcessor() {
        if (this.editorProcessor == null) {
            this.editorProcessor = this.createEditorProcessor(this.getEditorPattern());
        }
        return this.editorProcessor;
    }

    public String getEditPattern() {
        String string = super.getEditPattern();
        return string != null ? string : this.getDefaultPattern();
    }

    public void setEditPattern(String string) {
        super.setEditPattern(string);
        this.editProcessor = null;
    }

    protected MessageFormat createEditProcessor(String string) {
        return new MessageFormat(string);
    }

    protected MessageFormat getEditProcessor() {
        if (this.editProcessor == null) {
            this.editProcessor = this.createEditProcessor(this.getEditPattern());
        }
        return this.editProcessor;
    }

    public String getPrintString(IAdaptable iAdaptable, int n) {
        EObject eObject = (EObject)iAdaptable.getAdapter(EObject.class);
        return this.getViewProcessor().format(this.getValues(eObject), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String getEditString(IAdaptable iAdaptable, int n) {
        EObject eObject = (EObject)iAdaptable.getAdapter(EObject.class);
        return this.getEditorProcessor().format(this.getValues(eObject), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable iAdaptable, String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.getEditProcessor().parse(string, parsePosition);
        if (objectArray == null) {
            return new ParserEditStatus("eu.geclipse.workflow.ui", 1, "Invalid input at " + parsePosition.getErrorIndex());
        }
        return this.validateNewValues(objectArray);
    }

    public ICommand getParseCommand(IAdaptable iAdaptable, String string, int n) {
        Object[] objectArray = this.getEditProcessor().parse(string, new ParsePosition(0));
        return this.getParseCommand(iAdaptable, objectArray, n);
    }
}

