/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.part;

import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.workflow.ui.editor.WorkflowDiagramEditorUtil;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.part.Messages;
import eu.geclipse.workflow.ui.wizards.WorkflowNewDiagramFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class WorkflowInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.domainModelURI = null;
        iAction.setEnabled(false);
        if (!(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
            return;
        }
        IFile iFile = (IFile)((IStructuredSelection)iSelection).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        iAction.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction iAction) {
        Object object;
        TransactionalEditingDomain transactionalEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        EObject eObject = null;
        try {
            object = resourceSetImpl.getResource(this.domainModelURI, true);
            eObject = (EObject)object.getContents().get(0);
        }
        catch (WrappedException wrappedException) {
            WorkflowDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + this.domainModelURI, wrappedException);
        }
        if (eObject == null) {
            NewProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("WorkflowInitDiagramFileAction_InitDiagramFileResourceErrorDialogTitle"), (String)Messages.getString("WorkflowInitDiagramFileAction_InitDiagramFileResourceErrorDialogMessage"), null);
            return;
        }
        object = new WorkflowNewDiagramFileWizard(this.domainModelURI, eObject, transactionalEditingDomain);
        object.setWindowTitle(NLS.bind((String)Messages.getString("WorkflowInitDiagramFileAction_InitDiagramFileWizardTitle"), (Object)"Workflow"));
        WorkflowDiagramEditorUtil.runWizard(this.getShell(), (Wizard)object, "InitDiagramFile");
    }
}

