/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.part;

import eu.geclipse.workflow.IWorkflow;
import eu.geclipse.workflow.IWorkflowPackage;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class WorkflowVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(WorkflowDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Workflow".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return WorkflowVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation eAnnotation = view.getEAnnotation("Shortcut");
            if (eAnnotation != null) {
                return (String)eAnnotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                WorkflowDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + string);
            }
            return -1;
        }
    }

    public static String getType(int n) {
        return String.valueOf(n);
    }

    public static int getDiagramVisualID(EObject eObject) {
        if (eObject == null) {
            return -1;
        }
        if (IWorkflowPackage.eINSTANCE.getIWorkflow().isSuperTypeOf(eObject.eClass()) && WorkflowVisualIDRegistry.isDiagram((IWorkflow)eObject)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View view, EObject eObject) {
        if (eObject == null || !"Workflow".equals(WorkflowVisualIDRegistry.getModelID(view))) {
            return -1;
        }
        switch (WorkflowVisualIDRegistry.getVisualID(view)) {
            case 1001: {
                if (IWorkflowPackage.eINSTANCE.getIOutputPort().isSuperTypeOf(eObject.eClass())) {
                    return 2001;
                }
                if (!IWorkflowPackage.eINSTANCE.getIInputPort().isSuperTypeOf(eObject.eClass())) break;
                return 2002;
            }
            case 79: {
                if (!IWorkflowPackage.eINSTANCE.getIWorkflowJob().isSuperTypeOf(eObject.eClass())) break;
                return 1001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View view, int n) {
        int n2;
        String string = WorkflowVisualIDRegistry.getModelID(view);
        if (!"Workflow".equals(string)) {
            return false;
        }
        if ("Workflow".equals(string)) {
            n2 = WorkflowVisualIDRegistry.getVisualID(view);
        } else if (view instanceof Diagram) {
            n2 = 79;
        } else {
            return false;
        }
        switch (n2) {
            case 1001: {
                if (4001 == n) {
                    return true;
                }
                if (4002 == n) {
                    return true;
                }
                if (2001 == n) {
                    return true;
                }
                if (2002 != n) break;
                return true;
            }
            case 79: {
                if (1001 != n) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject eObject) {
        if (eObject == null) {
            return -1;
        }
        if (IWorkflowPackage.eINSTANCE.getILink().isSuperTypeOf(eObject.eClass())) {
            return 3001;
        }
        return -1;
    }

    private static boolean isDiagram(IWorkflow iWorkflow) {
        return true;
    }
}

