/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.wizards;

import eu.geclipse.workflow.ui.editor.WorkflowDiagramEditorUtil;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.wizards.WorkflowCreationWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class WorkflowCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected WorkflowCreationWizardPage diagramModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean bl) {
        this.openNewlyCreatedDiagramEditor = bl;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle("New Workflow Diagram");
        this.setDefaultPageImageDescriptor(WorkflowDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewWorkflowWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new WorkflowCreationWizardPage("DiagramModelFile", this.getSelection(), "workflow");
        this.diagramModelFilePage.setTitle("Create Workflow Diagram");
        this.diagramModelFilePage.setDescription("Select file that will contain diagram and domain models.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                WorkflowCreationWizard.this.diagram = WorkflowDiagramEditorUtil.createDiagram(WorkflowCreationWizard.this.diagramModelFilePage.getURI(), iProgressMonitor);
                if (WorkflowCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && WorkflowCreationWizard.this.diagram != null) {
                    try {
                        WorkflowDiagramEditorUtil.openDiagram(WorkflowCreationWizard.this.diagram);
                    }
                    catch (PartInitException partInitException) {
                        ErrorDialog.openError((Shell)WorkflowCreationWizard.this.getContainer().getShell(), (String)"Error opening diagram editor", null, (IStatus)partInitException.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                WorkflowDiagramEditorPlugin.getInstance().logError("Error creating diagram", invocationTargetException.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

