/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.wizards;

import eu.geclipse.workflow.ui.editor.WorkflowDiagramEditorUtil;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.part.Messages;
import eu.geclipse.workflow.ui.part.ModelElementSelectionPage;
import eu.geclipse.workflow.ui.part.WorkflowVisualIDRegistry;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class WorkflowNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;

    public WorkflowNewDiagramFileWizard(URI uRI, EObject eObject, TransactionalEditingDomain transactionalEditingDomain) {
        Path path;
        assert (uRI != null) : "Domain model uri must be specified";
        assert (eObject != null) : "Doagram root element must be specified";
        assert (transactionalEditingDomain != null) : "Editing domain must be specified";
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.getString("WorkflowNewDiagramFileWizard_CreationPageName"), (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.getString("WorkflowNewDiagramFileWizard_CreationPageTitle"));
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.getString("WorkflowNewDiagramFileWizard_CreationPageDescription"), (Object)"Workflow"));
        String string = uRI.trimFileExtension().lastSegment();
        if (uRI.isPlatformResource()) {
            path = new Path(uRI.trimSegments(1).toPlatformString(true));
        } else if (uRI.isFile()) {
            path = new Path(uRI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + uRI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)path);
        this.myFileCreationPage.setFileName(WorkflowDiagramEditorUtil.getUniqueFileName((IPath)path, string, "workflow"));
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageName"));
        this.diagramRootElementSelectionPage.setTitle(Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageTitle"));
        this.diagramRootElementSelectionPage.setDescription(Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageDescription"));
        this.diagramRootElementSelectionPage.setModelElement(eObject);
        this.myEditingDomain = transactionalEditingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myFileCreationPage);
        this.addPage((IWizardPage)this.diagramRootElementSelectionPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        IFile iFile = this.myFileCreationPage.createNewFile();
        WorkflowDiagramEditorUtil.setCharset(iFile);
        linkedList.add(iFile);
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource resource = resourceSet.createResource(uRI);
        AbstractTransactionalCommand abstractTransactionalCommand = new AbstractTransactionalCommand(this.myEditingDomain, Messages.getString("WorkflowNewDiagramFileWizard_InitDiagramCommand"), linkedList){

            protected CommandResult doExecuteWithResult(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                int n = WorkflowVisualIDRegistry.getDiagramVisualID(WorkflowNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (n != 79) {
                    return CommandResult.newErrorCommandResult((String)Messages.getString("WorkflowNewDiagramFileWizard_IncorrectRootError"));
                }
                Diagram diagram = ViewService.createDiagram((EObject)WorkflowNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"Workflow", (PreferencesHint)WorkflowDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                resource.getContents().add((Object)diagram);
                resource.getContents().add((Object)diagram.getElement());
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)abstractTransactionalCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            resource.save(WorkflowDiagramEditorUtil.getSaveOptions());
            WorkflowDiagramEditorUtil.openDiagram(resource);
        }
        catch (ExecutionException executionException) {
            WorkflowDiagramEditorPlugin.getInstance().logError(Messages.getString("WorkflowInitDiagramFileAction_UnableToCreateModelAndDiagram"), executionException);
        }
        catch (IOException iOException) {
            WorkflowDiagramEditorPlugin.getInstance().logError(String.valueOf(Messages.getString("WorkflowInitDiagramFileAction_SaveOperationFailedFor")) + uRI, iOException);
        }
        catch (PartInitException partInitException) {
            WorkflowDiagramEditorPlugin.getInstance().logError(Messages.getString("WorkflowInitDiagramFileAction_UnableToOpenEditor"), partInitException);
        }
        return true;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String string) {
            super(string);
        }

        protected String getSelectionTitle() {
            return Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageSelectionTitle");
        }

        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage(Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageNoSelectionMessage"));
                return false;
            }
            boolean bl = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "Workflow", WorkflowDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(bl ? null : Messages.getString("WorkflowNewDiagramFileWizard_RootSelectionPageInvalidSelectionMessage"));
            return bl;
        }
    }
}

