/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.typica.jaxb.InstanceStateType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationDescription {
    private String owner;
    private String resId;
    private List<Instance> instances = new ArrayList<Instance>();
    private List<String> groups = new ArrayList<String>();

    public ReservationDescription(String owner, String resId) {
        this.owner = owner;
        this.resId = resId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getReservationId() {
        return this.resId;
    }

    public Instance addInstance(String imageId, String instanceId, String privateDnsName, String dnsName, InstanceStateType state, String reason, String keyName, Calendar launchTime, InstanceType instanceType, String availabilityZone, String kernelId, String ramdiskId) {
        Instance instance = new Instance(imageId, instanceId, privateDnsName, dnsName, state.getName(), state.getCode(), reason, keyName, instanceType, launchTime, availabilityZone, kernelId, ramdiskId);
        this.instances.add(instance);
        return instance;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public String addGroup(String groupId) {
        this.groups.add(groupId);
        return groupId;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String toString() {
        return "Reservation[id=" + this.resId + ", Loc=" + ", instances=" + this.instances + ", groups=" + this.groups + "]";
    }

    public class Instance {
        private String imageId;
        private String instanceId;
        private String privateDnsName;
        private String dnsName;
        private String reason;
        private String keyName;
        private InstanceType instanceType;
        private Calendar launchTime;
        private String availabilityZone;
        private String kernelId;
        private String ramdiskId;
        private String state;
        private int stateCode;

        public Instance(String imageId, String instanceId, String privateDnsName, String dnsName, String stateName, int stateCode, String reason, String keyName, InstanceType instanceType, Calendar launchTime, String availabilityZone, String kernelId, String ramdiskId) {
            this.imageId = imageId;
            this.instanceId = instanceId;
            this.privateDnsName = privateDnsName;
            this.dnsName = dnsName;
            this.state = stateName;
            this.stateCode = stateCode;
            this.reason = reason;
            this.keyName = keyName;
            this.instanceType = instanceType;
            this.launchTime = launchTime;
            this.availabilityZone = availabilityZone;
            this.kernelId = kernelId;
            this.ramdiskId = ramdiskId;
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public String getDnsName() {
            return this.dnsName;
        }

        public String getReason() {
            return this.reason;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getState() {
            return this.state;
        }

        public boolean isRunning() {
            return this.state.equals("running");
        }

        public boolean isPending() {
            return this.state.equals("pending");
        }

        public boolean isShuttingDown() {
            return this.state.equals("shutting-down");
        }

        public boolean isTerminated() {
            return this.state.equals("terminated");
        }

        public int getStateCode() {
            return this.stateCode;
        }

        public InstanceType getInstanceType() {
            return this.instanceType;
        }

        public Calendar getLaunchTime() {
            return this.launchTime;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public String getKernelId() {
            return this.kernelId;
        }

        public String getRamdiskId() {
            return this.ramdiskId;
        }

        public String toString() {
            return "[img=" + this.imageId + ", instance=" + this.instanceId + ", privateDns=" + this.privateDnsName + ", dns=" + this.dnsName + ", loc=" + ", state=" + this.state + "(" + this.stateCode + ") reason=" + this.reason + "]";
        }
    }
}

