/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.sdb.Counter;
import com.xerox.amazonws.sdb.Item;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.ItemListener;
import com.xerox.amazonws.sdb.SDBException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttrWorker
implements Runnable {
    private Item item;
    private Counter running;
    private Map<String, List<ItemAttribute>> results;
    private ItemListener listener;

    public AttrWorker(Item item, Counter running, Map<String, List<ItemAttribute>> results, ItemListener listener) {
        this.item = item;
        this.running = running;
        this.results = results;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            Counter counter;
            try {
                try {
                    if (this.results != null) {
                        this.results.put(this.item.getIdentifier(), this.item.getAttributes());
                    } else if (this.listener != null) {
                        this.listener.itemAvailable(this.item.getIdentifier(), this.item.getAttributes());
                    }
                    done = true;
                }
                catch (SDBException sdbex) {
                    System.err.println("some sdb error, retrying... " + sdbex.getMessage());
                    counter = this.running;
                    synchronized (counter) {
                        this.running.decrement();
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                counter = this.running;
                synchronized (counter) {
                    this.running.decrement();
                }
                throw throwable;
            }
            counter = this.running;
            synchronized (counter) {
                this.running.decrement();
            }
        }
    }
}

