/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.AttrWorker;
import com.xerox.amazonws.sdb.Counter;
import com.xerox.amazonws.sdb.Item;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.ItemListener;
import com.xerox.amazonws.sdb.QueryResult;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.QueryResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Domain.class);
    private String domainName;
    private int maxThreads = 30;
    private ThreadPoolExecutor executor;

    protected Domain(String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.domainName = domainName;
        SimpleDB.setVersionHeader(this);
    }

    public String getName() {
        return this.domainName;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int threads) {
        this.maxThreads = threads;
    }

    public Item getItem(String identifier) throws SDBException {
        Item ret = new Item(identifier, this.domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public QueryResult listItems() throws SDBException {
        return this.listItems(null);
    }

    public QueryResult listItems(String queryString) throws SDBException {
        return this.listItems(queryString, null);
    }

    public QueryResult listItems(String queryString, String nextToken) throws SDBException {
        return this.listItems(queryString, null, 0);
    }

    public QueryResult listItems(String queryString, String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("QueryExpression", queryString == null ? "" : queryString);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfItems", "" + maxResults);
        }
        GetMethod method = new GetMethod();
        try {
            QueryResponse response = this.makeRequest((HttpMethodBase)method, "Query", params, QueryResponse.class);
            QueryResult queryResult = new QueryResult(response.getQueryResult().getNextToken(), Item.createList(response.getQueryResult().getItemNames().toArray(new String[0]), this.domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getSignatureVersion(), this.getHttpClient()));
            return queryResult;
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ItemAttribute>> getItemsAttributes(List<String> items) throws SDBException {
        Hashtable<String, List<ItemAttribute>> results = new Hashtable<String, List<ItemAttribute>>();
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        Counter running = new Counter(0);
        for (String item : items) {
            while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Counter counter = running;
            synchronized (counter) {
                running.increment();
            }
            pool.execute(new AttrWorker(this.getItem(item), running, results, null));
            Thread.yield();
        }
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getItemsAttributes(List<String> items, ItemListener listener) throws SDBException {
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        Counter running = new Counter(0);
        for (String item : items) {
            while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Counter counter = running;
            synchronized (counter) {
                running.increment();
            }
            pool.execute(new AttrWorker(this.getItem(item), running, null, listener));
            Thread.yield();
        }
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listItemsAttributes(String queryString, ItemListener listener) throws SDBException {
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        String nextToken = "";
        Counter running = new Counter(0);
        do {
            try {
                QueryResult result = this.listItems(queryString, nextToken, 250);
                List<Item> items = result.getItemList();
                for (Item i : items) {
                    while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Counter counter = running;
                    synchronized (counter) {
                        running.increment();
                    }
                    pool.execute(new AttrWorker(i, running, null, listener));
                    Thread.yield();
                }
                nextToken = result.getNextToken();
            }
            catch (SDBException ex) {
                System.out.println("Query '" + queryString + "' Failure: ");
                ex.printStackTrace();
            }
        } while (nextToken != null && nextToken.trim().length() > 0);
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
    }

    public void deleteItem(String identifier) throws SDBException {
        this.getItem(identifier).deleteAttributes(null);
    }

    static List<Domain> createList(String[] domainNames, String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int signatureVersion, HttpClient hc) throws SDBException {
        ArrayList<Domain> ret = new ArrayList<Domain>();
        int i = 0;
        while (i < domainNames.length) {
            Domain dom = new Domain(domainNames[i], awsAccessKeyId, awsSecretAccessKey, isSecure, server);
            dom.setSignatureVersion(signatureVersion);
            dom.setHttpClient(hc);
            ret.add(dom);
            ++i;
        }
        return ret;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxThreads));
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    protected class RejectionHandler
    implements RejectedExecutionHandler {
        protected RejectionHandler() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    }
}

