/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs.MessageQueue;
import com.xerox.amazonws.sqs.SQSException;
import com.xerox.amazonws.typica.jaxb.CreateQueueResponse;
import com.xerox.amazonws.typica.jaxb.ListQueuesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueService
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(QueueService.class);

    public QueueService(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "queue.amazonaws.com");
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        QueueService.setVersionHeader(this);
    }

    public MessageQueue getOrCreateMessageQueue(String queueName) throws SQSException {
        if (queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http")) {
            return this.getMessageQueue(queueName);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("QueueName", queueName);
        GetMethod method = new GetMethod();
        try {
            CreateQueueResponse response = this.makeRequest((HttpMethodBase)method, "CreateQueue", params, CreateQueueResponse.class);
            MessageQueue mq = new MessageQueue(response.getQueueUrl(), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
            mq.setHttpClient(this.getHttpClient());
            MessageQueue messageQueue = mq;
            return messageQueue;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public MessageQueue getMessageQueue(String queueName) throws SQSException {
        if (!(queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http"))) {
            throw new IllegalArgumentException("Queue name must be more fuly specified or use getOrCreateMessageQueue().");
        }
        MessageQueue mq = new MessageQueue(queueName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
        mq.setHttpClient(this.getHttpClient());
        return mq;
    }

    public List<MessageQueue> listMessageQueues(String queueNamePrefix) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queueNamePrefix != null && !queueNamePrefix.trim().equals("")) {
            params.put("QueueNamePrefix", queueNamePrefix);
        }
        GetMethod method = new GetMethod();
        try {
            ListQueuesResponse response = this.makeRequest((HttpMethodBase)method, "ListQueues", params, ListQueuesResponse.class);
            List<MessageQueue> list = MessageQueue.createList(response.getQueueUrls().toArray(new String[0]), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getHttpClient());
            return list;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2007-05-01");
        connection.getHeaders().put("Version", vals);
    }
}

