/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.wizards.EditAMIAttributesWizard;
import eu.geclipse.core.model.IGridElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class EditAMIAttributesAction
extends AbstractAWSProjectAction {
    private List<EC2AMIImage> amiList = new ArrayList<EC2AMIImage>();

    public void run(IAction action) {
        if (this.getAwsVo() != null && this.amiList.size() == 1) {
            EditAMIAttributesWizard wizard = new EditAMIAttributesWizard(this.getAwsVo(), this.amiList.get(0));
            WizardDialog wizardDialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
            wizardDialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.amiList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2AMIImage)) continue;
                EC2AMIImage ami = (EC2AMIImage)element;
                this.amiList.add(ami);
            }
        }
        if (this.amiList.size() == 1) {
            enable = true;
            this.extractAWSVoFromGridElement((IGridElement)this.amiList.get(0));
        }
        action.setEnabled(enable);
    }
}

