/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpRebootInstances;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RebootInstances
extends AbstractAWSProjectAction {
    private ArrayList<EC2Instance> instanceList = new ArrayList();

    public void run(IAction action) {
        if (action.isEnabled()) {
            Job job = new Job(Messages.getString("TerminateInstance.job_title")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IEC2 ec2;
                        if (RebootInstances.this.instanceList.size() == 0) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        monitor.beginTask(Messages.getString("RebootInstances.monitor_title"), 2);
                        RebootInstances.this.extractAWSVoFromGridElement((IGridElement)RebootInstances.this.instanceList.get(0));
                        try {
                            ec2 = EC2Registry.getRegistry().getEC2(RebootInstances.this.getAwsVo());
                        }
                        catch (ProblemException problemEx) {
                            Activator.log("Can not obtain IEC2 instance", (Exception)((Object)problemEx));
                            IStatus iStatus = Status.CANCEL_STATUS;
                            monitor.done();
                            return iStatus;
                        }
                        monitor.worked(1);
                        ArrayList<String> instanceIds = new ArrayList<String>(RebootInstances.this.instanceList.size());
                        for (EC2Instance instance : RebootInstances.this.instanceList) {
                            instanceIds.add(instance.getInstanceId());
                        }
                        EC2OpRebootInstances opRebootInstances = new EC2OpRebootInstances(ec2, instanceIds);
                        new OperationExecuter().execOp((IOperation)opRebootInstances);
                        if (opRebootInstances.getException() != null) {
                            Exception cause = opRebootInstances.getException();
                            RebootInstances.this.processException(cause, Messages.getString("RebootInstances.problem_description"));
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setPriority(20);
            job.setUser(true);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.instanceList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Instance)) continue;
                EC2Instance ec2Instance = (EC2Instance)element;
                this.instanceList.add(ec2Instance);
            }
        }
        if (this.instanceList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

