/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import com.xerox.amazonws.ec2.AddressInfo;
import eu.geclipse.aws.ec2.EC2ElasticIPAddress;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpReleaseAddress;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ReleaseElasticIPAction
extends AbstractAWSProjectAction {
    private List<EC2ElasticIPAddress> elasticIPList = new ArrayList<EC2ElasticIPAddress>();

    public void run(IAction action) {
        Job job = new Job(Messages.getString("ReleaseElasticIPAction.job_title")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IEC2 ec2;
                    if (ReleaseElasticIPAction.this.elasticIPList.size() == 0) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.beginTask(Messages.getString("ReleaseElasticIPAction.monitor_title"), 2);
                    ReleaseElasticIPAction.this.extractAWSVoFromGridElement((IGridElement)ReleaseElasticIPAction.this.elasticIPList.get(0));
                    try {
                        ec2 = EC2Registry.getRegistry().getEC2(ReleaseElasticIPAction.this.getAwsVo());
                    }
                    catch (ProblemException problemEx) {
                        Activator.log("Can not obtain IEC2 instance", (Exception)((Object)problemEx));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    monitor.worked(1);
                    AddressInfo addressInfo = ((EC2ElasticIPAddress)ReleaseElasticIPAction.this.elasticIPList.get(0)).getAddressInfo();
                    EC2OpReleaseAddress opReleaseAddress = new EC2OpReleaseAddress(ec2, addressInfo.getPublicIp());
                    new OperationExecuter().execOp((IOperation)opReleaseAddress);
                    if (opReleaseAddress.getException() != null) {
                        Exception cause = opReleaseAddress.getException();
                        ReleaseElasticIPAction.this.processException(cause, Messages.getString("ReleaseElasticIPAction.problem_description"));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.elasticIPList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2ElasticIPAddress)) continue;
                EC2ElasticIPAddress elasticIp = (EC2ElasticIPAddress)element;
                this.elasticIPList.add(elasticIp);
            }
        }
        if (this.elasticIPList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

