/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.launch;

import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.ui.widgets.StoredCombo;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EC2ParameterTab
extends AbstractLaunchConfigurationTab
implements Listener,
ModifyListener {
    private static final int USER_DATA_FILE_SIZE_LIMIT = 16000;
    private Text userDataText;
    private StoredCombo userDataFileCombo;
    private Composite userDataFileComp;
    private Composite userDataStringComp;
    private Button userDataStringRadio;
    private Button userDataFileRadio;
    private Button userDataFileButton;
    private ILaunchConfiguration launchConfiguration;

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        Group machineGroup = new Group(mainComp, 0);
        machineGroup.setLayout((Layout)new GridLayout(1, false));
        machineGroup.setText(Messages.getString("EC2ParameterTab.group_machine_title"));
        GridData gData = new GridData(4, 4, true, true);
        machineGroup.setLayoutData((Object)gData);
        this.userDataStringRadio = new Button((Composite)machineGroup, 16);
        this.userDataStringRadio.setText(Messages.getString("EC2ParameterTab.label_user_data_via_text"));
        this.userDataStringRadio.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.userDataStringRadio.addListener(13, (Listener)this);
        this.userDataStringRadio.setSelection(true);
        this.userDataStringComp = new Composite((Composite)machineGroup, 0);
        gData = new GridData(4, 4, true, true);
        gData.horizontalIndent = 15;
        this.userDataStringComp.setLayoutData((Object)gData);
        this.userDataStringComp.setLayout((Layout)new GridLayout(2, false));
        Label userDataLabel = new Label(this.userDataStringComp, 16384);
        userDataLabel.setText(Messages.getString("EC2ParameterTab.label_user_data"));
        userDataLabel.setToolTipText(Messages.getString("EC2ParameterTab.tooltip_user_data"));
        gData = new GridData(16384, 128, false, false);
        userDataLabel.setLayoutData((Object)gData);
        this.userDataText = new Text(this.userDataStringComp, 19010);
        gData = new GridData(4, 4, true, true);
        gData.heightHint = 60;
        this.userDataText.setLayoutData((Object)gData);
        this.userDataText.addModifyListener((ModifyListener)this);
        this.userDataFileRadio = new Button((Composite)machineGroup, 16);
        this.userDataFileRadio.setText(Messages.getString("EC2ParameterTab.label_user_data_via_file"));
        this.userDataFileRadio.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.userDataFileRadio.addListener(13, (Listener)this);
        this.userDataFileComp = new Composite((Composite)machineGroup, 0);
        gData = new GridData(4, 16384, true, false);
        gData.horizontalIndent = 15;
        this.userDataFileComp.setLayoutData((Object)gData);
        this.userDataFileComp.setLayout((Layout)new GridLayout(3, false));
        Label userDataFileLabel = new Label(this.userDataFileComp, 16384);
        userDataFileLabel.setText(Messages.getString("EC2ParameterTab.label_user_data_file"));
        gData = new GridData(16384, 0x1000000, false, false);
        userDataFileLabel.setLayoutData((Object)gData);
        this.userDataFileCombo = new StoredCombo(this.userDataFileComp, 16384);
        gData = new GridData(4, 0x1000000, true, false);
        this.userDataFileCombo.setLayoutData((Object)gData);
        this.userDataFileCombo.addModifyListener((ModifyListener)this);
        this.userDataFileButton = new Button(this.userDataFileComp, 0x1000000);
        this.userDataFileButton.setText(Messages.getString("EC2ParameterTab.button_browse_file"));
        this.userDataFileButton.addListener(13, (Listener)this);
        this.setEnabled((Control)this.userDataFileComp, false);
        this.setControl((Control)mainComp);
    }

    public String getName() {
        return Messages.getString("EC2ParameterTab.tab_title");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        try {
            this.userDataText.setText(configuration.getAttribute("userData", ""));
        }
        catch (CoreException coreEx) {
            Activator.log("Could not prepopulate launch dialog", (Exception)((Object)coreEx));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.userDataStringRadio.getSelection()) {
            configuration.setAttribute("userData", this.userDataText.getText());
        } else if (this.userDataFileRadio.getSelection()) {
            configuration.setAttribute("userDataFilePath", this.userDataFileCombo.getText());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String error = null;
        String userDataFilePath = this.userDataFileCombo.getText().trim();
        if (userDataFilePath.length() > 0 && this.userDataFileRadio.getSelection()) {
            File userDataFile = new File(userDataFilePath);
            if (!userDataFile.exists()) {
                error = Messages.getString("EC2ParameterTab.error_no_user_data_file");
            } else if (userDataFile.length() > 16000L) {
                error = Messages.getString("EC2ParameterTab.error_user_data_file_to_big");
            }
        }
        if (error != null) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.setEnabled(childControl, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.userDataStringRadio) {
            this.setEnabled((Control)this.userDataStringComp, true);
            this.setEnabled((Control)this.userDataFileComp, false);
        } else if (event.widget == this.userDataFileRadio) {
            this.setEnabled((Control)this.userDataStringComp, false);
            this.setEnabled((Control)this.userDataFileComp, true);
        } else if (event.widget == this.userDataFileButton) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4100);
            fileDialog.setText(Messages.getString("EC2ParameterTab.dialog_title_select_file_user_data"));
            String selectedFile = fileDialog.open();
            this.userDataFileCombo.setText(selectedFile);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            this.performApply(this.launchConfiguration.getWorkingCopy());
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreEx) {
            Activator.log("Problems applying the launch configuration", (Exception)((Object)coreEx));
        }
    }
}

