/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import com.xerox.amazonws.ec2.KeyPairInfo;
import eu.geclipse.aws.ec2.EC2Keypair;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeypairPropertySource
extends AbstractPropertySource<Object> {
    private EC2Keypair ec2Keypair;
    private List<IProperty<Object>> propertiesList;

    public KeypairPropertySource(EC2Keypair sourceObject) {
        super((Object)sourceObject);
        this.ec2Keypair = sourceObject;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        KeyPairInfo keyPairInfo = this.ec2Keypair.getKeyPairInfo();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("KeypairPropertySource.property_name"), keyPairInfo.getKeyName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("KeypairPropertySource.property_fingerprint"), keyPairInfo.getKeyFingerprint()));
        return propertyList;
    }
}

