/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.KeyPairInfo;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpCreateKeypair;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.CreateKeypairWizardPage;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateKeypairWizard
extends Wizard {
    private AWSVirtualOrganization awsVo;
    private CreateKeypairWizardPage wizardPage;

    public CreateKeypairWizard(AWSVirtualOrganization awsVo) {
        this.awsVo = awsVo;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.wizardPage = new CreateKeypairWizardPage(this.awsVo);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("CreateKeypairWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String keypairName = CreateKeypairWizard.this.wizardPage.getKeypairName();
                        monitor.beginTask(String.valueOf(Messages.getString("CreateKeypairWizard.task_title")) + keypairName, -1);
                        EC2OpCreateKeypair op = CreateKeypairWizard.this.createKeypairOnEC2(keypairName);
                        if (op.getException() != null) {
                            throw new InvocationTargetException(op.getException());
                        }
                        KeyPairInfo keypairInfo = op.getResult();
                        String keyMaterial = keypairInfo.getKeyMaterial();
                        CreateKeypairWizard.this.writeKeymaterialToDisc(keyMaterial);
                        monitor.done();
                    }
                });
            }
            catch (Exception ex) {
                Activator.log("A problem occured while creating a keypair", ex);
                final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("CreateKeypairWizard.error_ec2_title"), (String)(String.valueOf(Messages.getString("CreateKeypairWizard.error_ec2_description")) + CreateKeypairWizard.this.wizardPage.getKeypairName()), (Throwable)exception);
                    }
                });
                return false;
            }
            return true;
        }
        return false;
    }

    private void writeKeymaterialToDisc(String keyMaterial) throws InvocationTargetException {
        OutputStreamWriter fileWriter = null;
        try {
            try {
                File keyFile = new File(this.wizardPage.getKeypairPath());
                if (!keyFile.exists()) {
                    File parent = keyFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    keyFile.createNewFile();
                }
                fileWriter = new FileWriter(keyFile);
                fileWriter.write(keyMaterial);
            }
            catch (IOException ioEx) {
                Activator.log("Could not create keypair file", ioEx);
                throw new InvocationTargetException(ioEx, "Could not create keypair file");
            }
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ioEx) {
                    Activator.log("Could not close keypair file", ioEx);
                    throw new InvocationTargetException(ioEx, "Could not close keypair file");
                }
            }
        }
    }

    private EC2OpCreateKeypair createKeypairOnEC2(String keypairName) {
        EC2Registry registry = EC2Registry.getRegistry();
        IEC2 ec2 = null;
        try {
            ec2 = registry.getEC2(this.awsVo);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain the aws vo properties", (Exception)((Object)problemEx));
        }
        EC2OpCreateKeypair op = new EC2OpCreateKeypair(ec2, keypairName);
        new OperationExecuter().execOp((IOperation)op);
        return op;
    }
}

