/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpCreateSecurityGroup;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.CreateSecurityGroupWizardPage;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateSecurityGroupWizard
extends Wizard {
    private AWSVirtualOrganization awsVo;
    private CreateSecurityGroupWizardPage wizardPage;

    public CreateSecurityGroupWizard(AWSVirtualOrganization awsVo) {
        this.awsVo = awsVo;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.wizardPage = new CreateSecurityGroupWizardPage(this.awsVo);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("CreateSecurityGroupWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String securityGroupName = CreateSecurityGroupWizard.this.wizardPage.getSecurityGroupName();
                        String securityGroupDescription = CreateSecurityGroupWizard.this.wizardPage.getSecurityGroupDescription();
                        monitor.beginTask(String.valueOf(Messages.getString("CreateSecurityGroupWizard.task_title")) + securityGroupName, 2);
                        EC2Registry registry = EC2Registry.getRegistry();
                        IEC2 ec2 = null;
                        try {
                            ec2 = registry.getEC2(CreateSecurityGroupWizard.this.awsVo);
                        }
                        catch (ProblemException problemEx) {
                            Activator.log("Could not obtain the aws vo properties", (Exception)((Object)problemEx));
                        }
                        EC2OpCreateSecurityGroup op = new EC2OpCreateSecurityGroup(ec2, securityGroupName, securityGroupDescription);
                        new OperationExecuter().execOp((IOperation)op);
                        monitor.worked(1);
                        if (op.getException() != null) {
                            throw new InvocationTargetException(op.getException());
                        }
                        monitor.done();
                    }
                });
            }
            catch (Exception ex) {
                Activator.log("An problem occured while creating a security group", ex);
                final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("CreateSecurityGroupWizard.problem_title_ec2"), (String)(String.valueOf(Messages.getString("CreateSecurityGroupWizard.problem_description_ec2")) + CreateSecurityGroupWizard.this.wizardPage.getSecurityGroupName()), (Throwable)exception);
                    }
                });
                return false;
            }
            return true;
        }
        return false;
    }
}

