/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateSecurityGroupWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizards.createSecurityGroupWizardPage";
    private Text textName;
    private Text textDescription;

    public CreateSecurityGroupWizardPage(AWSVirtualOrganization awsVo) {
        super(WIZARD_PAGE_ID, Messages.getString("CreateSecurityGroupWizardPage.page_title"), null);
        String awsAccessId = null;
        try {
            awsAccessId = awsVo.getProperties().getAwsAccessId();
            this.setDescription(String.valueOf(Messages.getString("CreateSecurityGroupWizardPage.page_description1")) + awsAccessId + Messages.getString("CreateSecurityGroupWizardPage.page_description2"));
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
        }
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mainComp.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group(mainComp, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.getString("CreateSecurityGroupWizardPage.group_security_group_title"));
        Label labelName = new Label((Composite)group, 0);
        labelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelName.setText(Messages.getString("CreateSecurityGroupWizardPage.label_name"));
        this.textName = new Text((Composite)group, 18436);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSecurityGroupWizardPage.this.validatePage();
            }
        });
        Label labelDescription = new Label((Composite)group, 0);
        labelDescription.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelDescription.setText(Messages.getString("CreateSecurityGroupWizardPage.label_description"));
        this.textDescription = new Text((Composite)group, 18436);
        this.textDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setControl((Control)group);
    }

    private boolean validatePage() {
        String error = null;
        if (this.textName.getText().trim().length() == 0) {
            error = Messages.getString("CreateSecurityGroupWizardPage.error_security_group_requires_name");
        }
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    public String getSecurityGroupName() {
        return this.textName.getText().trim();
    }

    public String getSecurityGroupDescription() {
        return this.textDescription.getText().trim();
    }
}

