/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.util.AWSUtil;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GroupPermissionWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizard.groupPermission";
    private Text textAccountId;
    private Text textGroup;

    public GroupPermissionWizardPage(GroupDescription securityGroup) {
        super(WIZARD_PAGE_ID, String.valueOf(Messages.getString("GroupPermissionWizardPage.page_title")) + securityGroup.getName(), null);
        this.setDescription(String.valueOf(Messages.getString("GroupPermissionWizardPage.page_description")) + securityGroup.getName());
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        GridLayout gridLayout = new GridLayout(2, false);
        mainComp.setLayout((Layout)gridLayout);
        Label labelAccountId = new Label(mainComp, 0);
        labelAccountId.setText(Messages.getString("GroupPermissionWizardPage.label_account_id"));
        this.textAccountId = new Text(mainComp, 2048);
        this.textAccountId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textAccountId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GroupPermissionWizardPage.this.validateForm();
            }
        });
        Label labelGroup = new Label(mainComp, 0);
        labelGroup.setText(Messages.getString("GroupPermissionWizardPage.label_group"));
        this.textGroup = new Text(mainComp, 2048);
        this.textGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GroupPermissionWizardPage.this.validateForm();
            }
        });
        this.setControl((Control)parent);
    }

    private void validateForm() {
        String error = null;
        String transformedAccountNumber = AWSUtil.transformAWSAccountNumber((String)this.textAccountId.getText());
        if (transformedAccountNumber == null) {
            error = Messages.getString("GroupPermissionWizardPage.error_valid_account_id_required");
        }
        if (error == null && this.textGroup.getText().trim().length() == 0) {
            error = Messages.getString("GroupPermissionWizardPage.error_valid_security_group_required");
        }
        if (error == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(error);
            this.setPageComplete(false);
        }
    }

    public String getAccountId() {
        return AWSUtil.transformAWSAccountNumber((String)this.textAccountId.getText().trim());
    }

    public String getGroup() {
        return this.textGroup.getText().trim();
    }
}

