/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2;

import com.xerox.amazonws.ec2.ReservationDescription;
import eu.geclipse.aws.ec2.AbstractEC2GridResource;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import java.util.Calendar;

public class EC2Instance
extends AbstractEC2GridResource
implements IGridComputing {
    private ReservationDescription.Instance instance;

    public EC2Instance(IGridContainer parent, EC2Service ec2Service, ReservationDescription.Instance instance) {
        super(parent, ec2Service);
        this.instance = instance;
    }

    public String getHostName() {
        return this.instance.getDnsName();
    }

    public String getName() {
        StringBuilder strBuilder = new StringBuilder(this.instance.getInstanceId());
        strBuilder.append(" (");
        strBuilder.append(this.instance.getImageId());
        strBuilder.append(") - ");
        strBuilder.append(this.instance.getState());
        return strBuilder.toString();
    }

    public String getInstanceId() {
        return this.instance.getInstanceId();
    }

    public String getAvailabilityZone() {
        return this.instance.getAvailabilityZone();
    }

    public String getDnsName() {
        return this.instance.getDnsName();
    }

    public String getImageId() {
        return this.instance.getImageId();
    }

    public String getInstanceType() {
        return this.instance.getInstanceType().getTypeId();
    }

    public String getKernelId() {
        return this.instance.getKernelId();
    }

    public String getKeyName() {
        return this.instance.getKeyName();
    }

    public Calendar getLaunchTime() {
        return this.instance.getLaunchTime();
    }

    public String getPrivateDnsName() {
        return this.instance.getPrivateDnsName();
    }

    public String getRamdiskId() {
        return this.instance.getRamdiskId();
    }

    public String getReason() {
        return this.instance.getReason();
    }

    public String getState() {
        return this.instance.getState();
    }

    public int getStateCode() {
        return this.instance.getStateCode();
    }
}

