/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2;

import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.ec2.EC2;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.ISecurityManagerListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EC2Registry
implements ISecurityManagerListener {
    private Hashtable<String, IEC2> services = new Hashtable();

    public static EC2Registry getRegistry() {
        return SingletonHolder.instance;
    }

    private EC2Registry() {
        AuthenticationTokenManager.getManager().addListener((ISecurityManagerListener)this);
    }

    public void clear() {
        this.services.clear();
    }

    public IEC2 getEC2(AWSVirtualOrganization awsVo) throws ProblemException {
        String awsAccessId = awsVo.getProperties().getAwsAccessId();
        IEC2 existingService = this.services.get(awsAccessId);
        if (existingService == null) {
            EC2 ec2 = new EC2(awsVo);
            this.services.put(awsAccessId, ec2);
            return ec2;
        }
        return existingService;
    }

    public IEC2 getEC2(String awsAccessId) {
        IEC2 existingService = this.services.get(awsAccessId);
        if (existingService == null) {
            EC2 ec2 = new EC2(awsAccessId);
            this.services.put(awsAccessId, ec2);
            return ec2;
        }
        return existingService;
    }

    public void contentChanged(ISecurityManager manager) {
        if (manager instanceof AuthenticationTokenManager) {
            AuthenticationTokenManager authTokenManager = (AuthenticationTokenManager)manager;
            List tokens = authTokenManager.getTokens();
            Set<Map.Entry<String, IEC2>> entrySet = this.services.entrySet();
            ArrayList<String> elementsToRemove = new ArrayList<String>(this.services.size());
            for (Map.Entry<String, IEC2> entry : entrySet) {
                boolean found = false;
                for (IAuthenticationToken authToken : tokens) {
                    if (!(authToken.getDescription() instanceof AWSAuthTokenDescription)) continue;
                    AWSAuthTokenDescription awsAuthTokenDesc = (AWSAuthTokenDescription)authToken.getDescription();
                    if (!entry.getKey().equals(awsAuthTokenDesc.getAwsAccessId())) continue;
                    found = true;
                }
                if (found) continue;
                elementsToRemove.add(entry.getKey());
            }
            for (String awsAccessId : elementsToRemove) {
                this.services.remove(awsAccessId);
            }
        }
    }

    /* synthetic */ EC2Registry(EC2Registry eC2Registry) {
        this();
    }

    private static class SingletonHolder {
        private static final EC2Registry instance = new EC2Registry(null);

        private SingletonHolder() {
        }
    }
}

