/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpAuthorizeSecurityGroup
implements IOperation {
    private final IEC2 ec2Service;
    private Exception exception;
    private String groupName;
    private String ipProtocol;
    private int fromPort;
    private int toPort;
    private String cidrIp;
    private String secGroupName;
    private String secGroupOwnerId;

    public EC2OpAuthorizeSecurityGroup(IEC2 ec2Service) {
        this.ec2Service = ec2Service;
    }

    public EC2OpAuthorizeSecurityGroup(IEC2 ec2Service, String groupName, String cidrIp, String ipProtocol, int fromPort, int toPort) {
        this.ec2Service = ec2Service;
        this.groupName = groupName;
        this.ipProtocol = ipProtocol;
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.cidrIp = cidrIp;
    }

    public EC2OpAuthorizeSecurityGroup(IEC2 ec2Service, String groupName, String secGroupName, String secGroupOwnerId) {
        this.ec2Service = ec2Service;
        this.groupName = groupName;
        this.secGroupName = secGroupName;
        this.secGroupOwnerId = secGroupOwnerId;
    }

    @Override
    public void run() {
        this.exception = null;
        try {
            if (this.secGroupOwnerId != null) {
                this.ec2Service.authorizeSecurityGroup(this.groupName, this.secGroupName, this.secGroupOwnerId);
            } else {
                this.ec2Service.authorizeSecurityGroup(this.groupName, this.cidrIp, this.ipProtocol, this.fromPort, this.toPort);
            }
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    @Override
    public List<Object> getResult() {
        return null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(int fromPort) {
        this.fromPort = fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public void setToPort(int toPort) {
        this.toPort = toPort;
    }

    public String getCidrIp() {
        return this.cidrIp;
    }

    public void setCidrIp(String cidrIp) {
        this.cidrIp = cidrIp;
    }

    public String getSecGroupName() {
        return this.secGroupName;
    }

    public void setSecGroupName(String secGroupName) {
        this.secGroupName = secGroupName;
    }

    public String getSecGroupOwnerId() {
        return this.secGroupOwnerId;
    }

    public void setSecGroupOwnerId(String secGroupOwnerId) {
        this.secGroupOwnerId = secGroupOwnerId;
    }

    public IEC2 getEc2Service() {
        return this.ec2Service;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }
}

