/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import com.xerox.amazonws.ec2.AvailabilityZone;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpDescribeAvailabilityZones
implements IOperation {
    private final IEC2 ec2Service;
    private List<String> availabilityZonesList;
    private List<AvailabilityZone> result;
    private Exception exception;

    public EC2OpDescribeAvailabilityZones(IEC2 ec2Service) {
        this.ec2Service = ec2Service;
        this.availabilityZonesList = new ArrayList<String>();
    }

    public EC2OpDescribeAvailabilityZones(IEC2 ec2Service, String[] availabilityZonesArray) {
        this.ec2Service = ec2Service;
        this.availabilityZonesList = Arrays.asList(availabilityZonesArray);
    }

    public EC2OpDescribeAvailabilityZones(IEC2 ec2Service, List<String> availabilityZonesList) {
        this.ec2Service = ec2Service;
        this.availabilityZonesList = availabilityZonesList;
    }

    @Override
    public void run() {
        this.result = null;
        this.exception = null;
        try {
            this.result = this.ec2Service.describeAvailabilityZones(this.availabilityZonesList);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    @Override
    public List<AvailabilityZone> getResult() {
        return this.result;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

