/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import com.xerox.amazonws.ec2.ReservationDescription;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpDescribeInstances
implements IOperation {
    private final IEC2 ec2Service;
    private List<String> instanceList;
    private List<ReservationDescription> result;
    private Exception exception;

    public EC2OpDescribeInstances(IEC2 ec2Service) {
        this.ec2Service = ec2Service;
        this.instanceList = new ArrayList<String>();
    }

    public EC2OpDescribeInstances(IEC2 ec2Service, String[] instanceArray) {
        this.ec2Service = ec2Service;
        this.instanceList = Arrays.asList(instanceArray);
    }

    public EC2OpDescribeInstances(IEC2 ec2Service, List<String> instanceList) {
        this.ec2Service = ec2Service;
        this.instanceList = instanceList;
    }

    @Override
    public void run() {
        this.result = null;
        this.exception = null;
        try {
            this.result = this.ec2Service.describeInstances(this.instanceList);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    @Override
    public List<ReservationDescription> getResult() {
        return this.result;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

