/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpDescribeSecurityGroups
implements IOperation {
    private final IEC2 ec2Service;
    private List<String> securityGroupList;
    private List<GroupDescription> result;
    private Exception exception;

    public EC2OpDescribeSecurityGroups(IEC2 ec2Service) {
        this.ec2Service = ec2Service;
        this.securityGroupList = new ArrayList<String>();
    }

    public EC2OpDescribeSecurityGroups(IEC2 ec2Service, String[] securityGroupArray) {
        this.ec2Service = ec2Service;
        this.securityGroupList = Arrays.asList(securityGroupArray);
    }

    public EC2OpDescribeSecurityGroups(IEC2 ec2Service, List<String> securityGroupList) {
        this.ec2Service = ec2Service;
        this.securityGroupList = securityGroupList;
    }

    @Override
    public void run() {
        this.result = null;
        this.exception = null;
        try {
            this.result = this.ec2Service.describeSecurityGroups(this.securityGroupList);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    @Override
    public List<GroupDescription> getResult() {
        return this.result;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

