/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpRevokeSecurityGroup
implements IOperation {
    private final IEC2 ec2Service;
    private Exception exception;
    private String groupName;
    private String ipProtocol;
    private int fromPort;
    private int toPort;
    private String cidrIp;
    private String secGroupName;
    private String secGroupOwnerId;

    public EC2OpRevokeSecurityGroup(IEC2 ec2Service, String groupName, String cidrIp, String ipProtocol, int fromPort, int toPort) {
        this.ec2Service = ec2Service;
        this.groupName = groupName;
        this.ipProtocol = ipProtocol;
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.cidrIp = cidrIp;
    }

    public EC2OpRevokeSecurityGroup(IEC2 ec2Service, String groupName, String secGroupName, String secGroupOwnerId) {
        this.ec2Service = ec2Service;
        this.groupName = groupName;
        this.secGroupName = secGroupName;
        this.secGroupOwnerId = secGroupOwnerId;
    }

    @Override
    public void run() {
        this.exception = null;
        try {
            if (this.secGroupOwnerId != null) {
                this.ec2Service.revokeSecurityGroup(this.groupName, this.secGroupName, this.secGroupOwnerId);
            } else {
                this.ec2Service.revokeSecurityGroup(this.groupName, this.cidrIp, this.ipProtocol, this.fromPort, this.toPort);
            }
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    @Override
    public List<Object> getResult() {
        return null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

