/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationSet;
import java.util.ArrayList;

public class OperationExecuter {
    private ArrayList<Thread> threadList;

    public synchronized IOperation execOp(IOperation op) {
        this.threadList = new ArrayList();
        this.exec(op);
        this.waitForOp();
        this.threadList.clear();
        return op;
    }

    public synchronized OperationSet execOpGroup(OperationSet opGroup) {
        this.threadList = new ArrayList();
        for (IOperation op : opGroup.getOps()) {
            this.exec(op);
        }
        this.waitForOp();
        this.threadList.clear();
        return opGroup;
    }

    private void exec(IOperation op) {
        Thread thread = new Thread((Runnable)op, op.getClass().getName());
        thread.run();
        this.threadList.add(thread);
    }

    private void waitForOp() {
        for (Thread thread : this.threadList) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedExc) {
                Activator.log("Interrupted while waiting for Operation on " + thread.getName(), interruptedExc);
            }
        }
    }
}

