/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.service;

import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.service.EC2InfoService;
import eu.geclipse.aws.ec2.service.EC2ServiceCreator;
import eu.geclipse.aws.ec2.service.EC2ServiceProperties;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class EC2Service
extends AbstractGridContainer
implements IAWSService,
IStorableElement {
    public static final String STORAGE_NAME = "eu.geclipse.aws.ec2.service.ec2ServiceCreator";
    private AWSVirtualOrganization awsVo;
    public static IGridResourceCategory[] standardResources = new IGridResourceCategory[]{GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.allImages"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.myOwned"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.myAccessible"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.securityGroups"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.keypairs"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.elasticIP")};

    public EC2Service(EC2ServiceCreator serviceCreator, AWSVirtualOrganization vo) {
        this.awsVo = vo;
        try {
            this.addElement((IGridElement)new EC2InfoService(vo, this));
            this.apply(serviceCreator);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not populate EC2Service with data from provided EC2 service creator and the infoservice", (Exception)((Object)problemEx));
        }
    }

    public EC2Service(AWSVirtualOrganization vo) {
        this.awsVo = vo;
        try {
            EC2ServiceProperties serviceProperties = new EC2ServiceProperties(this);
            serviceProperties.load();
            this.addElement((IGridElement)serviceProperties);
            this.addElement((IGridElement)new EC2InfoService(vo, this));
        }
        catch (ProblemException e) {
            Activator.log("Could not load the ec2 service details from the filestore", (Exception)((Object)e));
        }
    }

    public boolean canContain(IGridElement element) {
        return element instanceof EC2ServiceProperties || element instanceof EC2InfoService;
    }

    public void apply(EC2ServiceCreator serviceCreator) throws ProblemException {
        EC2ServiceProperties properties = new EC2ServiceProperties(this, serviceCreator);
        this.addElement((IGridElement)properties);
    }

    public IGridResourceCategory[] getSupportedResources() {
        return standardResources;
    }

    public String getHostName() {
        EC2ServiceProperties properties = null;
        try {
            properties = this.getProperties();
        }
        catch (ProblemException e) {
            Activator.log("Could not load the properties of the ec2 service", (Exception)((Object)e));
        }
        if (properties != null) {
            return properties.getEc2Url();
        }
        return null;
    }

    public URI getURI() {
        String hostName = this.getHostName();
        try {
            if (hostName != null) {
                return new URI(hostName);
            }
        }
        catch (URISyntaxException e) {
            Activator.log("Could not create EC2 service URI from " + hostName, e);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(STORAGE_NAME);
    }

    public String getName() {
        EC2ServiceProperties properties = null;
        try {
            properties = this.getProperties();
        }
        catch (ProblemException gridModelEx) {
            Activator.log("Could not load the properties of the ec2 service", (Exception)((Object)gridModelEx));
        }
        if (properties != null) {
            return properties.getServiceName();
        }
        return null;
    }

    public IGridContainer getParent() {
        return this.awsVo;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(STORAGE_NAME);
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof EC2Service) {
            result = this.equals((EC2Service)((Object)obj));
        }
        return result;
    }

    private boolean equals(EC2Service service) {
        return this.getName().equals(service.getName());
    }

    public EC2ServiceProperties getProperties() throws ProblemException {
        IGridElement[] children;
        EC2ServiceProperties properties = null;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof EC2ServiceProperties) {
                properties = (EC2ServiceProperties)child;
                break;
            }
            ++n2;
        }
        return properties;
    }

    public IGridInfoService getInfoService() {
        EC2InfoService infoService = null;
        try {
            IGridElement[] children;
            IGridElement[] iGridElementArray = children = this.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement child = iGridElementArray[n2];
                if (child instanceof IGridInfoService) {
                    infoService = (EC2InfoService)child;
                    break;
                }
                ++n2;
            }
        }
        catch (ProblemException gridModelEx) {
            Activator.log("Could not get info service from EC2Service", (Exception)((Object)gridModelEx));
        }
        return infoService;
    }

    public void load() throws ProblemException {
        this.deleteAll();
        this.addElement((IGridElement)new EC2InfoService(this.awsVo, this));
        IFileStore fileStore = this.getFileStore();
        try {
            IFileStore[] childStores;
            IFileStore[] iFileStoreArray = childStores = fileStore.childStores(0, null);
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (child.getName().equals(".ec2_service_properties")) {
                    EC2ServiceProperties serviceProperties = new EC2ServiceProperties(this);
                    serviceProperties.load();
                    this.addElement((IGridElement)serviceProperties);
                }
                ++n2;
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws.ec2");
        }
    }

    public void save() throws ProblemException {
        IGridElement[] children;
        IFileStore fileStore = this.getFileStore();
        if (!fileStore.fetchInfo().exists()) {
            try {
                fileStore.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log("Could not create storage dir for ec2Service", (Exception)((Object)e));
                return;
            }
        }
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IStorableElement) {
                ((IStorableElement)child).save();
            }
            ++n2;
        }
    }
}

