/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.service;

import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.service.EC2ServiceCreator;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class EC2ServiceProperties
extends AbstractGridElement
implements IStorableElement {
    public static final String STORAGE_NAME = ".ec2_service_properties";
    private EC2Service ec2Service;
    private String ec2Url;
    private String serviceName;

    public EC2ServiceProperties(EC2Service ec2Service) {
        this.ec2Service = ec2Service;
    }

    public EC2ServiceProperties(EC2Service ec2Service, EC2ServiceCreator serviceCreator) {
        this.ec2Service = ec2Service;
        this.ec2Url = serviceCreator.getServiceURL();
        this.serviceName = serviceCreator.getServiceName();
    }

    public void load() throws ProblemException {
        BufferedReader bufferedReader = null;
        try {
            try {
                String url;
                IFileStore fileStore = this.getFileStore();
                InputStream iStream = fileStore.openInputStream(0, null);
                InputStreamReader iReader = new InputStreamReader(iStream);
                bufferedReader = new BufferedReader(iReader);
                String serviceName = bufferedReader.readLine();
                if (serviceName != null && serviceName.trim().length() != 0) {
                    this.serviceName = serviceName;
                }
                if ((url = bufferedReader.readLine()) != null && url.trim().length() != 0) {
                    this.ec2Url = url;
                }
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.ec2");
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws.ec2");
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioExc) {
                    throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.ec2");
                }
            }
        }
    }

    public void save() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        BufferedWriter bWriter = null;
        try {
            try {
                OutputStream oStream = fileStore.openOutputStream(0, null);
                OutputStreamWriter osWriter = new OutputStreamWriter(oStream);
                bWriter = new BufferedWriter(osWriter);
                if (this.serviceName != null) {
                    bWriter.write(this.serviceName);
                }
                bWriter.write(10);
                if (this.ec2Url != null) {
                    bWriter.write(this.ec2Url);
                }
                bWriter.write(10);
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.ec2");
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)cExc, "eu.geclipse.aws.ec2");
            }
        }
        finally {
            try {
                if (bWriter != null) {
                    bWriter.close();
                }
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioExc, "eu.geclipse.aws.ec2");
            }
        }
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getName() {
        return STORAGE_NAME;
    }

    public IGridContainer getParent() {
        return this.ec2Service;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public String getEc2Url() {
        return this.ec2Url;
    }

    public void setEc2Url(String ec2Url) {
        this.ec2Url = ec2Url;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

