/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.internal.fileSystem;

import eu.geclipse.aws.s3.internal.Activator;
import eu.geclipse.aws.s3.internal.S3ServiceRegistry;
import eu.geclipse.core.reporting.ProblemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class S3FileStore
extends FileStore
implements IFileStore {
    private S3FileStore storeParent;
    private String storeName;
    private FileInfo storeInfo;

    public S3FileStore(String name) {
        this(null, name);
    }

    public S3FileStore(S3FileStore parent, String name) {
        this.storeParent = parent;
        this.storeName = name;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        String[] result = new String[]{};
        S3Service service = this.getService();
        if (service != null) {
            if (this.isRoot()) {
                result = S3FileStore.childNamesFromRoot(service);
            } else if (this.isBucket()) {
                result = S3FileStore.childNamesFromBucket(service, this.getName());
            }
        }
        return result;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.isBucket()) {
                S3Service service = this.getService();
                S3Bucket bucket = this.getBucket();
                service.deleteBucket(bucket);
            } else if (this.isObject()) {
                S3Service service = this.getService();
                S3Bucket bucket = this.getBucket();
                service.deleteObject(bucket, this.getName());
            }
            this.internalFetchInfo().setExists(false);
        }
        catch (S3ServiceException s3Exc) {
            throw new ProblemException("eu.geclipse.aws.s3.problem.deleteFailed", (Throwable)s3Exc, "eu.geclipse.aws.s3");
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.internalFetchInfo();
    }

    public IFileStore getChild(String name) {
        return new S3FileStore(this, name);
    }

    public String getName() {
        return this.storeName;
    }

    public IFileStore getParent() {
        return this.storeParent;
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (!this.isBucket()) {
            throw new ProblemException("eu.geclipse.aws.s3.problem.bucketInBucketFailed", "eu.geclipse.aws.s3");
        }
        S3Service service = this.getService();
        try {
            service.createBucket(this.getName());
            this.storeInfo = null;
        }
        catch (S3ServiceException s3Exc) {
            ProblemException pExc = new ProblemException("eu.geclipse.aws.s3.problem.bucketCreateFailed", (Throwable)s3Exc, "eu.geclipse.aws.s3");
            throw pExc;
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        InputStream result = null;
        S3Object object = this.getObject();
        if (object != null) {
            try {
                result = object.getDataInputStream();
            }
            catch (S3ServiceException s3Exc) {
                throw new ProblemException("eu.geclipse.aws.s3.problem.inputFailed", (Throwable)s3Exc, "eu.geclipse.aws.s3");
            }
        }
        this.internalFetchInfo().setExists(true);
        return result;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        PipedOutputStream result = null;
        if (this.isObject()) {
            try {
                final S3Service service = this.getService();
                final S3Bucket bucket = this.getBucket();
                final PipedOutputStream pos = result = new PipedOutputStream();
                final PipedInputStream pis = new PipedInputStream(result);
                final S3Object object = new S3Object(bucket, this.getName());
                object.setDataInputStream((InputStream)pis);
                Thread worker = new Thread(new Runnable(){

                    public void run() {
                        try {
                            service.putObject(bucket, object);
                            pos.close();
                            pis.close();
                        }
                        catch (S3ServiceException s3Exc) {
                            try {
                                S3FileStore.this.internalFetchInfo().setExists(false);
                            }
                            catch (ProblemException pExc) {
                                Activator.log((Exception)((Object)pExc));
                            }
                            Activator.log((Exception)((Object)s3Exc));
                        }
                        catch (IOException ioExc) {
                            Activator.log(ioExc);
                        }
                    }
                });
                worker.start();
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.aws.s3.problem.outputFailed", (Throwable)ioExc, "eu.geclipse.aws.s3");
            }
        }
        return result;
    }

    public URI toURI() {
        String authority = this.getName();
        String path = null;
        IFileStore par = this.getParent();
        if (par != null) {
            URI parURI = par.toURI();
            authority = parURI.getAuthority();
            path = parURI.getPath();
            path = path == null || path.length() == 0 ? "/" + this.getName() : String.valueOf(path) + "/" + this.getName();
        } else {
            authority = this.getAccessKeyID();
        }
        URI result = null;
        try {
            result = new URI("s3", authority, path, null, null);
        }
        catch (URISyntaxException uriExc) {
            Activator.log(uriExc);
        }
        return result;
    }

    protected FileInfo internalFetchInfo() throws ProblemException {
        if (this.storeInfo == null) {
            this.storeInfo = new FileInfo();
            this.storeInfo.setName(this.getName());
            this.storeInfo.setDirectory(this.isDirectory());
            this.storeInfo.setExists(false);
            if (this.isRoot()) {
                this.storeInfo.setExists(false);
            } else if (this.isBucket()) {
                try {
                    S3Service service = this.getService();
                    boolean exists = service != null && service.isBucketAccessible(this.getName());
                    this.storeInfo.setExists(exists);
                    this.storeInfo.setDirectory(exists);
                }
                catch (S3ServiceException s3ServiceException) {}
            } else if (this.isObject()) {
                S3Object object = this.getObjectDetails();
                this.storeInfo.setExists(object != null);
                if (object != null) {
                    this.storeInfo.setLastModified(object.getLastModifiedDate().getTime());
                    this.storeInfo.setLength(object.getContentLength());
                }
            }
        }
        return this.storeInfo;
    }

    private boolean isBucket() {
        return this.getParent() != null && this.getParent().getParent() == null;
    }

    private boolean isObject() {
        return !this.isRoot() && !this.isBucket();
    }

    private boolean isRoot() {
        return this.getParent() == null;
    }

    private String getAccessKeyID() {
        return this.isRoot() ? this.storeName : ((S3FileStore)this.getParent()).getAccessKeyID();
    }

    private S3Bucket getBucket() {
        S3Bucket result = null;
        if (this.isBucket()) {
            result = new S3Bucket(this.getName());
        } else if (this.isObject()) {
            result = ((S3FileStore)this.getParent()).getBucket();
        }
        return result;
    }

    private S3Object getObjectDetails() throws ProblemException {
        S3Object result = null;
        if (this.isObject()) {
            S3Service service = this.getService();
            S3Bucket bucket = this.getBucket();
            try {
                result = service.getObjectDetails(bucket, this.getName());
            }
            catch (S3ServiceException s3Exc) {
                throw new ProblemException("eu.geclipse.aws.s3.problem.objectLoadFailed", (Throwable)s3Exc, "eu.geclipse.aws.s3");
            }
        }
        return result;
    }

    private S3Object getObject() throws ProblemException {
        S3Object result = null;
        if (this.isObject()) {
            S3Service service = this.getService();
            S3Bucket bucket = this.getBucket();
            try {
                result = service.getObject(bucket, this.getName());
            }
            catch (S3ServiceException s3Exc) {
                throw new ProblemException("eu.geclipse.aws.s3.problem.objectLoadFailed", (Throwable)s3Exc, "eu.geclipse.aws.s3");
            }
        }
        return result;
    }

    private S3Service getService() throws ProblemException {
        S3Service service = S3ServiceRegistry.getRegistry().getService(this.getAccessKeyID());
        return service;
    }

    private boolean isDirectory() {
        return !this.isObject();
    }

    private static String[] childNamesFromRoot(S3Service service) throws ProblemException {
        String[] result = new String[]{};
        try {
            S3Bucket[] buckets = service.listAllBuckets();
            if (buckets != null) {
                result = new String[buckets.length];
                int i = 0;
                while (i < buckets.length) {
                    result[i] = buckets[i].getName();
                    ++i;
                }
            }
        }
        catch (S3ServiceException s3sExc) {
            throw new ProblemException("eu.geclipse.aws.s3.problem.listFailed", (Throwable)s3sExc, "eu.geclipse.aws.s3");
        }
        return result;
    }

    private static String[] childNamesFromBucket(S3Service service, String bucketName) throws ProblemException {
        String[] result = new String[]{};
        try {
            S3Bucket bucket = new S3Bucket(bucketName);
            S3Object[] objects = service.listObjects(bucket);
            if (objects != null) {
                result = new String[objects.length];
                int i = 0;
                while (i < objects.length) {
                    result[i] = objects[i].getKey();
                    ++i;
                }
            }
        }
        catch (S3ServiceException s3sExc) {
            throw new ProblemException("eu.geclipse.aws.s3.problem.listFailed", (Throwable)s3sExc, "eu.geclipse.aws.s3");
        }
        return result;
    }
}

