/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws;

import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.internal.Activator;
import eu.geclipse.aws.internal.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridInfoService;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.info.model.AbstractGlueStore;
import eu.geclipse.info.model.IExtendedGridInfoService;
import eu.geclipse.info.model.InfoTopTreeElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSInfoService
extends AbstractGridInfoService
implements IExtendedGridInfoService {
    public static String STORAGE_NAME = ".awsInfoService";
    private AWSVirtualOrganization awsVo;

    public AWSInfoService(AWSVirtualOrganization virtualOrganization) {
        this.awsVo = virtualOrganization;
    }

    public AbstractGlueStore getStore() {
        return null;
    }

    public ArrayList<InfoTopTreeElement> getTopTreeElements() {
        return null;
    }

    public String getVoType() {
        return this.awsVo.getTypeName();
    }

    public void scheduleFetch(IProgressMonitor monitor) {
    }

    public void setVO(IVirtualOrganization vo) {
        this.awsVo = (AWSVirtualOrganization)vo;
    }

    public IGridResource[] fetchResources(IGridContainer parent, IVirtualOrganization vo, IGridResourceCategory category, boolean exclusive, Class<? extends IGridResource> typeFilter, IProgressMonitor monitor) throws ProblemException {
        List<IAWSService> awsServices = null;
        try {
            awsServices = this.awsVo.getChildren(monitor, IAWSService.class);
        }
        catch (ProblemException pEx) {
            Activator.log("Could not load child services", (Exception)((Object)pEx));
        }
        ArrayList gridResourcesList = null;
        if (awsServices != null) {
            gridResourcesList = new ArrayList();
            for (IAWSService service : awsServices) {
                IGridInfoService infoService = service.getInfoService();
                if (infoService == null) continue;
                IGridResource[] gridResource = infoService.fetchResources(parent, vo, category, exclusive, typeFilter, monitor);
                Collections.addAll(gridResourcesList, gridResource);
            }
        }
        if (gridResourcesList != null) {
            return gridResourcesList.toArray(new IGridResource[gridResourcesList.size()]);
        }
        return new IGridResource[0];
    }

    public String getHostName() {
        return null;
    }

    public URI getURI() {
        try {
            return new URI(Messages.getString("AWSInfoService.aws_uri"));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(STORAGE_NAME);
    }

    public String getName() {
        return "AWS @ " + this.getURI();
    }

    public IGridContainer getParent() {
        return this.awsVo;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(STORAGE_NAME);
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }
}

